/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
/******************************************************************************
  gpack.h

This file is part of the STARLab Magellan Altimeter Data Processing Software.
Michael Maurer, February 1994.
******************************************************************************/
/* $Log: gpack.h,v $
 * Revision 1.0  1994/03/04  22:13:16  maurer
 * Initial revision
 * */

#ifndef GPACK_H
#define GPACK_H

#define UCHAR_LO	0
#define UCHAR_HI	(255-5)
#define UCHAR_RES1	(UCHAR_HI+1)
#define UCHAR_RES2	(UCHAR_HI+2)
#define UCHAR_RES3	(UCHAR_HI+3)
#define UCHAR_RES4	(UCHAR_HI+4)
#define UCHAR_RES5	(UCHAR_HI+5)

#define USHRT_LO	0
#define USHRT_HI	(65535-5)
#define USHRT_RES1	(USHRT_HI+1)
#define USHRT_RES2	(USHRT_HI+2)
#define USHRT_RES3	(USHRT_HI+3)
#define USHRT_RES4	(USHRT_HI+4)
#define USHRT_RES5	(USHRT_HI+5)

typedef enum {
   sc_Linear,
   sc_Log10,
   sc_dBv,
   sc_dBp
} scale_t;

typedef struct {
   double	lo;
   double	hi;
   scale_t	sc;
   short	nb;
} range_t;

#endif /* GPACK_H */
