/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
#ifdef GPACK_C
/*
 *   This file was automatically generated by version 1.7 of cextract.
 *   Manual editing not recommended.
 *
 *   Created: Wed May 11 02:10:39 1994
 */
#ifndef gpack_H
#define gpack_H
#if __STDC__

int gpack ( double d, range_t rg );
double gpack_maximum ( range_t rg );
double gpack_minimum ( range_t rg );
static double gpack_scale ( double d, range_t rg );
double gpack_scaling ( range_t rg );
static unsigned char gpack_uchar ( double d, double lo, double hi );
static double gpack_unscale ( double d, range_t rg );
static unsigned short gpack_ushort ( double d, double lo, double hi );
static double gscaling_uchar ( double lo, double hi );
static double gscaling_ushort ( double lo, double hi );
double gunpack ( int i, range_t rg );
static double gunpack_uchar ( unsigned char u, double lo, double hi );
static double gunpack_ushort ( unsigned short u, double lo, double hi );

#else /* __STDC__ */

int gpack (/* double d, range_t rg */);
double gpack_maximum (/* range_t rg */);
double gpack_minimum (/* range_t rg */);
static double gpack_scale (/* double d, range_t rg */);
double gpack_scaling (/* range_t rg */);
static unsigned char gpack_uchar (/* double d, double lo, double hi */);
static double gpack_unscale (/* double d, range_t rg */);
static unsigned short gpack_ushort (/* double d, double lo, double hi */);
static double gscaling_uchar (/* double lo, double hi */);
static double gscaling_ushort (/* double lo, double hi */);
double gunpack (/* int i, range_t rg */);
static double gunpack_uchar (/* unsigned char u, double lo, double hi */);
static double gunpack_ushort (/* unsigned short u, double lo, double hi */);

#endif /* __STDC__ */
#endif /* gpack_H */
#else /* GPACK_C */
/*
 *   This file was automatically generated by version 1.7 of cextract.
 *   Manual editing not recommended.
 *
 *   Created: Wed May 11 02:10:40 1994
 */
#ifndef gpack_H
#define gpack_H
#if __STDC__

extern int gpack ( double d, range_t rg );
extern double gpack_maximum ( range_t rg );
extern double gpack_minimum ( range_t rg );
extern double gpack_scaling ( range_t rg );
extern double gunpack ( int i, range_t rg );

#else /* __STDC__ */

extern int gpack (/* double d, range_t rg */);
extern double gpack_maximum (/* range_t rg */);
extern double gpack_minimum (/* range_t rg */);
extern double gpack_scaling (/* range_t rg */);
extern double gunpack (/* int i, range_t rg */);

#endif /* __STDC__ */
#endif /* gpack_H */
#endif /* GPACK_C */
