/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
/******************************************************************************
  gpds.h

This file is part of the STARLab Magellan Altimeter Data Processing Software.
Michael Maurer, August 1993.
******************************************************************************/
/* $Log: gpds.h,v $
 * Revision 1.2  1994/04/29  02:00:19  maurer
 * Added #include ability for DESCRIPTION fields.
 *
 * Revision 1.1  1993/11/24  18:31:11  maurer
 * Added wrap field to PDS line data structure.
 *
 * Revision 1.0  1993/08/25  20:48:43  maurer
 * Initial revision
 * */

#ifndef GPDS_H
#define GPDS_H

#define PDS_NUL		0
#define PDS_LIT		1
#define PDS_FMT		2
#define PDS_INC		3

typedef struct {
   int	flag;
   char *fmt;
   char *val;
   char *wrap;
} pdsentry_t;

typedef struct pdslist_t_ {
   pdsentry_t		this;
   struct pdslist_t_	*prev;
   struct pdslist_t_	*next;
} pdslist_t;


#endif /* GPDS_H */
