/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
#ifdef GPDS_C
/*
 *   This file was automatically generated by version 1.7 of cextract.
 *   Manual editing not recommended.
 *
 *   Created: Wed May 11 02:10:43 1994
 */
#ifndef gpds_H
#define gpds_H
#if __STDC__

void gpds_free ( pdslist_t *L );
char * gpds_key ( pdsentry_t *ent );
static pdsentry_t * gpds_lookup ( pdslist_t *head, char *obj, char *key );
static int gpds_match ( pdsentry_t *ent, char *key );
int gpds_print ( FILE *fp, pdslist_t *head, int reclen, int indent1 );
static int gpds_print1 ( FILE *fp, pdsentry_t *ent, int reclen, int indent );
static int gpds_printinc ( FILE *fp, pdsentry_t *ent, int reclen, int indent );
int gpds_rfmt ( FILE *fp, pdslist_t **head );
static int gpds_rfmt1 ( FILE *fp, pdslist_t *head );
int gpds_setinc ( pdslist_t *head, char *obj, char *key, char *fn );
int gpds_setwrap ( pdslist_t *head, char *obj, char *key, char *wrap );
static int gpds_spitout ( char *s, FILE *fp, pdsentry_t *ent, int reclen, int indent );
int gpds_sprintf ( pdslist_t *head, char *obj, char *key, ... );
static char * gpds_str ( pdsentry_t *ent );
char * gpds_val ( pdsentry_t *ent );
static int has_sprintf ( char *s );
static int list_append ( pdslist_t *head, pdsentry_t *ent );
static void list_free ( pdslist_t *L );
static pdslist_t * list_new ( void );
static char * strnrpbrk ( char *s1, char *s2, int n );
static char * strrpbrk ( char *s1, char *s2 );
static int strrspn ( char *s1, char *s2 );

#else /* __STDC__ */

void gpds_free (/* pdslist_t *L */);
char * gpds_key (/* pdsentry_t *ent */);
static pdsentry_t * gpds_lookup (/* pdslist_t *head, char *obj, char *key */);
static int gpds_match (/* pdsentry_t *ent, char *key */);
int gpds_print (/* FILE *fp, pdslist_t *head, int reclen, int indent1 */);
static int gpds_print1 (/* FILE *fp, pdsentry_t *ent, int reclen, int indent */);
static int gpds_printinc (/* FILE *fp, pdsentry_t *ent, int reclen, int indent */);
int gpds_rfmt (/* FILE *fp, pdslist_t **head */);
static int gpds_rfmt1 (/* FILE *fp, pdslist_t *head */);
int gpds_setinc (/* pdslist_t *head, char *obj, char *key, char *fn */);
int gpds_setwrap (/* pdslist_t *head, char *obj, char *key, char *wrap */);
static int gpds_spitout (/* char *s, FILE *fp, pdsentry_t *ent, int reclen, int indent */);
int gpds_sprintf (/* pdslist_t *head, char *obj, char *key, ... */);
static char * gpds_str (/* pdsentry_t *ent */);
char * gpds_val (/* pdsentry_t *ent */);
static int has_sprintf (/* char *s */);
static int list_append (/* pdslist_t *head, pdsentry_t *ent */);
static void list_free (/* pdslist_t *L */);
static pdslist_t * list_new (/* void */);
static char * strnrpbrk (/* char *s1, char *s2, int n */);
static char * strrpbrk (/* char *s1, char *s2 */);
static int strrspn (/* char *s1, char *s2 */);

#endif /* __STDC__ */
#endif /* gpds_H */
#else /* GPDS_C */
/*
 *   This file was automatically generated by version 1.7 of cextract.
 *   Manual editing not recommended.
 *
 *   Created: Wed May 11 02:10:44 1994
 */
#ifndef gpds_H
#define gpds_H
#if __STDC__

extern void gpds_free ( pdslist_t *L );
extern char * gpds_key ( pdsentry_t *ent );
extern int gpds_print ( FILE *fp, pdslist_t *head, int reclen, int indent1 );
extern int gpds_rfmt ( FILE *fp, pdslist_t **head );
extern int gpds_setinc ( pdslist_t *head, char *obj, char *key, char *fn );
extern int gpds_setwrap ( pdslist_t *head, char *obj, char *key, char *wrap );
extern int gpds_sprintf ( pdslist_t *head, char *obj, char *key, ... );
extern char * gpds_val ( pdsentry_t *ent );

#else /* __STDC__ */

extern void gpds_free (/* pdslist_t *L */);
extern char * gpds_key (/* pdsentry_t *ent */);
extern int gpds_print (/* FILE *fp, pdslist_t *head, int reclen, int indent1 */);
extern int gpds_rfmt (/* FILE *fp, pdslist_t **head */);
extern int gpds_setinc (/* pdslist_t *head, char *obj, char *key, char *fn */);
extern int gpds_setwrap (/* pdslist_t *head, char *obj, char *key, char *wrap */);
extern int gpds_sprintf (/* pdslist_t *head, char *obj, char *key, ... */);
extern char * gpds_val (/* pdsentry_t *ent */);

#endif /* __STDC__ */
#endif /* gpds_H */
#endif /* GPDS_C */
