/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
static char rcsid[]="$Id: gv_cvt.c,v 1.6 1994/03/04 22:05:49 maurer Exp $";
/******************************************************************************
  gv_cvt.c

     Function: Convert between native machine format and GVDR file format.

This file is part of the STARLab Magellan Altimeter Data Processing Software.
Michael Maurer, May 1993.
******************************************************************************/
/* $Log: gv_cvt.c,v $
 * Revision 1.6  1994/03/04  22:05:49  maurer
 * Updated header conversion.
 *
 * Revision 1.5  1994/01/06  00:17:24  maurer
 * Updated to convert new gvdr_sfduhdr_t field gh_ANF_Nazim.
 *
 * Revision 1.4  1993/08/25  21:15:46  maurer
 * Added reclen conversion to GVDR cell header conversion.
 * Added ADF conversion.
 * Updated binary file header conversion.
 * Updated index conversion.
 *
 * Revision 1.3  1993/08/02  00:59:48  maurer
 * Now part of the GVDR reader set.
 * Changed type of gar_dcent.
 *
 * Revision 1.2  1993/07/30  02:01:43  maurer
 * Added conversions for new index.
 *
 * Revision 1.1  1993/07/03  23:47:25  maurer
 * Updated to use new GVDR record format.
 *
 * Revision 1.0  1993/06/12  00:37:37  maurer
 * Initial revision
 * */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libmisc.h"
#include "gvdr.h"

#define GVDR_CVT_C
#include "gv_cvt.p"
#include "gcvt.p"


/******************************************************************************
  gcvt_cell

Convert gvdrcell_rec to/from local format, in place.
******************************************************************************/

void
gcvt_cell(gvdrcell_rec *Cr)
{
   gcvt_s(&Cr->gvr_reclen,&Cr->gvr_reclen,1);		/* reclen */
}

void
gcvt_xif(gvdrxif_rec *gr)
{
   gcvt_s(&gr->gxr_Nlooks,&gr->gxr_Nlooks,3);		/* Nlooks...inc */
}

void
gcvt_edf(gvdredf_rec *gr)
{
   gcvt_s(&gr->ger_Nlooks,&gr->ger_Nlooks,3);		/* Nlooks...inc */
   gcvt_s(&gr->ger_emiss,&gr->ger_emiss,1);		/* emiss */
}

void
gcvt_adf(gvdradf_rec *gr)
{
   gcvt_s(&gr->gdr_Nlooks,&gr->gdr_Nlooks,3);		/* Nlooks...radiushi */
}

void
gcvt_anf(gvdranf_rec *gr)
{
   gcvt_s(&gr->gar_reclen,&gr->gar_reclen,2);		/* reclen...Nlooks */
#ifndef NEWANF
   gcvt_s(&gr->gar_dcent,&gr->gar_dcent,1);		/* dcent */
#endif
}

void
gcvt_hdr(gvdr_sfduhdr_t *gh)
{
   gcvt_l(&gh->gh_rec_tile,&gh->gh_rec_tile,2);			/* gh_rec_tile...gh_max_tlen */
   gcvt_s(&gh->gh_rec_pixel,&gh->gh_rec_pixel,21);		/* gh_rec_pixel...gh_tile_npy */
   gcvt_l(&gh->gh_proj_bbxlo,&gh->gh_proj_bbxlo,6);		/* gh_proj_bbxlo...gh_proj_samples */
   gcvt_d(&gh->gh_proj_aradius,&gh->gh_proj_aradius,7);		/* gh_proj_aradius...gh_proj_cenlon */
   gcvt_l(&gh->gh_proj_linefirst,&gh->gh_proj_linefirst,4);	/* gh_proj_linefirst...gh_proj_samplelast */
   gcvt_d(&gh->gh_proj_rotation,&gh->gh_proj_rotation,9);	/* gh_proj_rotation...gh_proj_sampleoffset */
}

void
gcvt_indexh(gvdr_index_rec*Ir)
{
   gcvt_s(&Ir->lo,&Ir->lo,4);				/* lo...mult */
}

void
gcvt_index(gvdr_index_t *I)
{
   int nelem;

   nelem = I->hi - I->lo + 1;
   switch (I->nb) {
    case 4:
      gcvt_l(I->index,I->index,nelem);
      break;
    case 2:
      gcvt_s(I->index,I->index,nelem);
      break;
    case 1:
      break;
    default:
      error(-1,0,"[gcvt_index] illegal byte size");
   }
}
