/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
/******************************************************************************
  gv_pack.h

This file is part of the STARLab Magellan Altimeter Data Processing Software.
Michael Maurer, June 1993.
******************************************************************************/
/* $Log: gv_pack.h,v $
 * Revision 1.3  1994/03/04  22:06:34  maurer
 * Replaced #defines with data structures.
 *
 * Revision 1.2  1993/08/25  21:21:14  maurer
 * Moved UCHAR_* and USHRT_* from gv_pack.c to gv_pack.h.
 * Added ADF min/max definitions.
 * Added comments for log10 parameters.
 *
 * Revision 1.1  1993/08/02  01:01:15  maurer
 * Added EMISSV and DCENT values.
 *
 * Revision 1.0  1993/07/03  23:48:45  maurer
 * Initial revision
 * */

#ifndef GVDR_PACK_H
#define GVDR_PACK_H

#include "gpack.h"

static range_t rg_azim		= {    0.0,  360.0, sc_Linear, 2};
static range_t rg_inc		= {    0.0,   90.0, sc_Linear, 2};
static range_t rg_poln		= {  -90.0,   90.0, sc_Linear, 1};
static range_t rg_c0		= {  -35.0,   15.0, sc_Linear, 1}; /* already in dB */
static range_t rg_c1		= {   -5.0,    5.0, sc_Linear, 1};
static range_t rg_c2		= {  -15.0,   15.0, sc_Linear, 1};

static range_t rg_emiss		= {    0.0,    1.0, sc_Linear, 2};
static range_t rg_emissv	= {   -5.0,   -1.0, sc_Log10,  1};

static range_t rg_radius	= { 6040.0, 6070.0, sc_Linear, 2};
static range_t rg_radiusv	= {    0.0,    5.0, sc_Linear, 2};
static range_t rg_slope		= {    0.0,   15.0, sc_Linear, 1};
static range_t rg_slopev	= {   -3.0,    2.0, sc_Log10,  1};
static range_t rg_rho		= {   -2.5,    0.0, sc_Log10,  1};
static range_t rg_rhov		= {   -7.0,    0.0, sc_Log10,  1};

static range_t rg_sig0		= {   -3.0,    3.0, sc_Log10,  1};
static range_t rg_Vsig0		= {   -3.0,    5.0, sc_Log10,  1};
#ifndef NEWAZIM
static range_t rg_dcent		= {-6000.0, 6000.0, sc_Linear, 2};
#else
static range_t rg_dcent		= {-4000.0, 4000.0, sc_Linear, 1};
#endif
static range_t rg_gazim		= {    0.0,  360.0, sc_Linear, 1};
static range_t rg_hagp1		= {    1.0,    4.0, sc_Log10,  1};
static range_t rg_hagp1v	= {    1.0,    7.0, sc_Log10,  1};
static range_t rg_expp1		= {   -3.0,    0.0, sc_Log10,  1};
static range_t rg_expp1v	= {   -9.0,   -3.0, sc_Log10,  1};
static range_t rg_gaup1		= {   -3.0,    0.0, sc_Log10,  1};
static range_t rg_gaup1v	= {   -9.0,   -3.0, sc_Log10,  1};
static range_t rg_rayp1		= {   -3.0,    0.0, sc_Log10,  1};
static range_t rg_rayp1v	= {   -9.0,   -3.0, sc_Log10,  1};
static range_t rg_muhp1		= {   -3.0,    0.0, sc_Log10,  1};
static range_t rg_muhp1v	= {   -9.0,   -3.0, sc_Log10,  1};
static range_t rg_p2		= {   -3.0,    0.0, sc_Log10,  1};
static range_t rg_p2v		= {   -9.0,    0.0, sc_Log10,  1};
static range_t rg_rms		= {    0.0,   20.0, sc_Linear, 1};
static range_t rg_rmsv		= {   -6.0,    1.0, sc_Log10,  1};
static range_t rg_resid		= {    0.0,  500.0, sc_Linear, 1};

/* these depend on order of enum in gvdr.h */
static range_t *rg_p1[] = {
   &rg_hagp1,
   &rg_expp1,
   &rg_gaup1,
   &rg_rayp1,
   &rg_muhp1
};

static range_t *rg_p1v[] = {
   &rg_hagp1v,
   &rg_expp1v,
   &rg_gaup1v,
   &rg_rayp1v,
   &rg_muhp1v
};

#endif /* GVDR_PACK_H */
