/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
static char rcsid[]="$Id: gv_proj.c,v 1.2 1994/04/29 02:01:00 maurer Exp $";
/******************************************************************************
  gv_proj.c

  Function:  Provide GVDR reader with interface to map projection modules.

This file is part of the STARLab Magellan Altimeter Data Processing Software.
Michael Maurer, November 1993.
******************************************************************************/
/* $Log: gv_proj.c,v $
 * Revision 1.2  1994/04/29  02:01:00  maurer
 * Fixed x0 and y0 to use correct offsets.  Added gvdr_fromlat().
 *
 * Revision 1.1  1994/01/06  00:20:27  maurer
 * Added proj.p.
 *
 * Revision 1.0  1993/11/24  18:41:26  maurer
 * Initial revision
 * */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libmisc.h"
#include "gvdr.h"
#include "proj.h"

#define GVDR_PROJ_C
#include "gv_proj.p"
#include "proj.p"

int
gvdr_rproj(gvdr_sfduhdr_t *gh,
	   proj_t *P)
{
   proj_clear(P);
   if (gh==NULL)
      return 1;
   if (gh->gh_proj_id != pjSinusoidal &&
       gh->gh_proj_id != pjMercator &&
       gh->gh_proj_id != pjStereographic &&
       gh->gh_proj_id != pjPolarStereo)
      return 2;
   P->proj		= gh->gh_proj_id;
   P->hemi		= gh->gh_proj_hemi;
   P->linlo		= gh->gh_proj_bbylo;
   P->linhi		= gh->gh_proj_bbyhi;
   P->par.eradius	= gh->gh_proj_aradius*1000;	/* convert km to m */
   P->par.pradius	= gh->gh_proj_cradius*1000;	/* convert km to m */
   P->par.xpixsiz	= gh->gh_proj_scale*1000;	/* convert km/pix to m/pix */
   P->par.ypixsiz	= P->par.xpixsiz;
   P->par.lon0		= gh->gh_proj_cenlon;
   P->par.lat0		= gh->gh_proj_cenlat;
   P->par.x0		= - gh->gh_proj_bbxlo - gh->gh_proj_sampleoffset;
   P->par.y0		= gh->gh_proj_lineoffset - gh->gh_proj_bbyhi;
   P->par.lonlo		= gh->gh_proj_minlon;
   P->par.lonhi		= gh->gh_proj_maxlon;
   P->par.latlo		= gh->gh_proj_minlat;
   P->par.lathi		= gh->gh_proj_maxlat;
   return 0;
}

int
gvdr_tolat(proj_t *P,
	   gvdrcell_t *gv)
{
   return proj_tolat(P,(double)gv->gv_X,(double)gv->gv_Y,&gv->gv_lon,&gv->gv_lat);
}

int
gvdr_fromlat(proj_t *P,
	     gvdrcell_t *gv)
{
   double X,Y;
   int err;

   if (err=proj_fromlat(P,gv->gv_lon,gv->gv_lat,&X,&Y))
      return err;
   gv->gv_X=(short)X;
   gv->gv_Y=(short)Y;
   return 0;
}
