/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
/******************************************************************************
  gv_sfdu.h

This file is part of the STARLab Magellan Altimeter Data Processing Software.
Michael Maurer, May 1993.
******************************************************************************/
/* $Log: gv_sfdu.h,v $
 * Revision 1.3  1993/11/24  18:33:11  maurer
 * Added MAP_HEMISPHERE_ID.
 *
 * Revision 1.2  1993/09/10  19:40:00  maurer
 * Removed FIRST_LINE and LAST_LINE.
 *
 * Revision 1.1  1993/08/02  01:01:42  maurer
 * Added static keycat_t records for reader/writer modules.
 *
 * Revision 1.0  1993/06/12  00:39:05  maurer
 * Initial revision
 * */

#ifndef GVDR_SFDU_H
#define GVDR_SFDU_H

#define LBL_PRIM	"CCSD1Z000001"
#define LBL_KEYS	"NJPL1K00KL00"
#define LBL_AGGR	"CCSD1R000003"

#define TYPE_GVDR_BHDR	"NJPL1I000900"
#define TYPE_GVDR_INDEX	"NJPL1I000901"
#define TYPE_GVDR_TILE	"NJPL1I000902"
#define TYPE_GVDR_PIXEL	"NJPL1I000903"

#define PROD_GVDR_TILE	"GVDR_TILE_DATA"
#define PROD_GVDR_PIXEL	"GVDR_PIXEL_DATA"

#include "sfdug.h"

static keycat_t keys_gvdr[] = {
   "PRODUCT_FILE_NAME",		K_MAL,	NULL,		NULL,
   "PRODUCT_TYPE",		K_CON,	NULL,		"GVDR_DATA",
   "PRODUCT_SEQUENCE_NUMBER",	K_FMT,	"%05d",		NULL,
   "MAP_PROJECTION_NAME",	K_MAL,	NULL,		NULL,
   "MAP_PROJECTION_ID",		K_FMT,	"%d",		NULL,
   "MAP_HEMISPHERE_NAME",	K_MAL,	NULL,		NULL,
   "MAP_HEMISPHERE_ID",		K_FMT,	"%d",		NULL,
   "INPUT_SEQUENCE_NUMBERS",	K_PTR,	NULL,		NULL,
   "MISSION_ID",		K_CON,	NULL,		"4",
   "MISSION_NAME",		K_CON,	NULL,		"MAGELLAN",
   "SPACECRAFT_ID",		K_CON,	NULL,		"18",
   "SPACECRAFT_NAME",		K_CON,	NULL,		"MAGELLAN",
   "HARDWARE_VERSION_ID_1",	K_FMT,	"%03d",		NULL,
   "HARDWARE_VERSION_ID_2",	K_FMT,	"%03d",		NULL,
   "HARDWARE_VERSION_ID_3",	K_FMT,	"%03d",		NULL,
   "MAJOR_SOFTWARE_VERSION_ID",	K_FMT,	"%03d",		NULL,
   "MINOR_SOFTWARE_VERSION_ID",	K_FMT,	"%03d",		NULL,
   "PROCESS_TIME",		K_MAL,	NULL,		NULL,
   "DATA_FORMAT_TYPE",		K_PTR,	NULL,		NULL,
   NULL,			K_NUL,	NULL,		NULL
};

static keycat_t keys_gsmarker[] = {
   "DELIMITER",			K_CON,	NULL,		"SMARKER",
   "PRODUCT_NAME",		K_CON,	NULL,		PROD_GVDR_TILE,
   "TYPE",			K_CON,	NULL,		TYPE_GVDR_TILE,
   NULL,			0,	NULL,		NULL
};

#endif /* GVDR_SFDU_H */
