/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
#ifdef GVDR_C
/*
 *   This file was automatically generated by version 1.7 of cextract.
 *   Manual editing not recommended.
 *
 *   Created: Wed May 11 02:10:46 1994
 */
#ifndef gvdr_H
#define gvdr_H
#if __STDC__

void gvdr_clear ( gvdrcell_t *C );
void gvdr_free ( gvdrcell_t *C );
int gvdr_mradf ( char **src, gvdradf_t *gadf, int Nadf );
int gvdr_mranf ( char **src, gvdranf_t *ganf, int Nanf, int Nsig0 );
int gvdr_mrcell ( char **src, gvdrcell_t *C );
static int gvdr_mrchdr ( char **src, gvdrcell_t *C );
int gvdr_mredf ( char **src, gvdredf_t *gedf, int Nedf );
int gvdr_mrxif ( char **src, gvdrxif_t *gxif, int Nxif );
int gvdr_parsehdr ( gvdrhdr_t *hdr );
int gvdr_pcell ( FILE *fp, gvdrcell_t *C );
char * gvdr_proc_time ( void );
int gvdr_psize ( FILE *fp, gvdrcell_t *C );
static int gvdr_radf ( FILE *fp, gvdradf_t *gadf, int Nadf );
static int gvdr_ranf ( FILE *fp, gvdranf_t *ganf, int Nanf );
int gvdr_rcell ( FILE *fp, gvdrcell_t *C );
static int gvdr_rchdr ( FILE *fp, gvdrcell_t *C );
void gvdr_realloc ( gvdrcell_t *C, int NAxif, int NAedf, int NAadf, int NAanf, int NAsig0, int NAfit );
static int gvdr_redf ( FILE *fp, gvdredf_t *gedf, int Nedf );
void gvdr_reset ( gvdrcell_t *C );
int gvdr_rhdr ( FILE *fp, gvdrhdr_t *hdr );
int gvdr_rihdr ( FILE *fp, int *len, fpos_t *iposp );
int gvdr_rlhdr ( FILE *fp, int *len );
int gvdr_rpad ( FILE *fp, unsigned int mult, char pad, fpos_t *fposp );
int gvdr_rtrl ( FILE *fp );
static int gvdr_rxif ( FILE *fp, gvdrxif_t *gxif, int Nxif );
int gvdr_seek1 ( FILE *fp, gvdr_index_t *I, int addr, fpos_t *fpos );
int gvdr_seek2 ( FILE *fp, gvdr_index_t *I1, gvdr_index_t *I2, int addr1, int addr2, fpos_t *fpos );
void gvdr_uchdr ( gvdrcell_t *C );

#else /* __STDC__ */

void gvdr_clear (/* gvdrcell_t *C */);
void gvdr_free (/* gvdrcell_t *C */);
int gvdr_mradf (/* char **src, gvdradf_t *gadf, int Nadf */);
int gvdr_mranf (/* char **src, gvdranf_t *ganf, int Nanf, int Nsig0 */);
int gvdr_mrcell (/* char **src, gvdrcell_t *C */);
static int gvdr_mrchdr (/* char **src, gvdrcell_t *C */);
int gvdr_mredf (/* char **src, gvdredf_t *gedf, int Nedf */);
int gvdr_mrxif (/* char **src, gvdrxif_t *gxif, int Nxif */);
int gvdr_parsehdr (/* gvdrhdr_t *hdr */);
int gvdr_pcell (/* FILE *fp, gvdrcell_t *C */);
char * gvdr_proc_time (/* void */);
int gvdr_psize (/* FILE *fp, gvdrcell_t *C */);
static int gvdr_radf (/* FILE *fp, gvdradf_t *gadf, int Nadf */);
static int gvdr_ranf (/* FILE *fp, gvdranf_t *ganf, int Nanf */);
int gvdr_rcell (/* FILE *fp, gvdrcell_t *C */);
static int gvdr_rchdr (/* FILE *fp, gvdrcell_t *C */);
void gvdr_realloc (/* gvdrcell_t *C, int NAxif, int NAedf, int NAadf, int NAanf, int NAsig0, int NAfit */);
static int gvdr_redf (/* FILE *fp, gvdredf_t *gedf, int Nedf */);
void gvdr_reset (/* gvdrcell_t *C */);
int gvdr_rhdr (/* FILE *fp, gvdrhdr_t *hdr */);
int gvdr_rihdr (/* FILE *fp, int *len, fpos_t *iposp */);
int gvdr_rlhdr (/* FILE *fp, int *len */);
int gvdr_rpad (/* FILE *fp, unsigned int mult, char pad, fpos_t *fposp */);
int gvdr_rtrl (/* FILE *fp */);
static int gvdr_rxif (/* FILE *fp, gvdrxif_t *gxif, int Nxif */);
int gvdr_seek1 (/* FILE *fp, gvdr_index_t *I, int addr, fpos_t *fpos */);
int gvdr_seek2 (/* FILE *fp, gvdr_index_t *I1, gvdr_index_t *I2, int addr1, int addr2, fpos_t *fpos */);
void gvdr_uchdr (/* gvdrcell_t *C */);

#endif /* __STDC__ */
#endif /* gvdr_H */
#else /* GVDR_C */
/*
 *   This file was automatically generated by version 1.7 of cextract.
 *   Manual editing not recommended.
 *
 *   Created: Wed May 11 02:10:47 1994
 */
#ifndef gvdr_H
#define gvdr_H
#if __STDC__

extern void gvdr_clear ( gvdrcell_t *C );
extern void gvdr_free ( gvdrcell_t *C );
extern int gvdr_mradf ( char **src, gvdradf_t *gadf, int Nadf );
extern int gvdr_mranf ( char **src, gvdranf_t *ganf, int Nanf, int Nsig0 );
extern int gvdr_mrcell ( char **src, gvdrcell_t *C );
extern int gvdr_mredf ( char **src, gvdredf_t *gedf, int Nedf );
extern int gvdr_mrxif ( char **src, gvdrxif_t *gxif, int Nxif );
extern int gvdr_parsehdr ( gvdrhdr_t *hdr );
extern int gvdr_pcell ( FILE *fp, gvdrcell_t *C );
extern char * gvdr_proc_time ( void );
extern int gvdr_psize ( FILE *fp, gvdrcell_t *C );
extern int gvdr_rcell ( FILE *fp, gvdrcell_t *C );
extern void gvdr_realloc ( gvdrcell_t *C, int NAxif, int NAedf, int NAadf, int NAanf, int NAsig0, int NAfit );
extern void gvdr_reset ( gvdrcell_t *C );
extern int gvdr_rhdr ( FILE *fp, gvdrhdr_t *hdr );
extern int gvdr_rihdr ( FILE *fp, int *len, fpos_t *iposp );
extern int gvdr_rlhdr ( FILE *fp, int *len );
extern int gvdr_rpad ( FILE *fp, unsigned int mult, char pad, fpos_t *fposp );
extern int gvdr_rtrl ( FILE *fp );
extern int gvdr_seek1 ( FILE *fp, gvdr_index_t *I, int addr, fpos_t *fpos );
extern int gvdr_seek2 ( FILE *fp, gvdr_index_t *I1, gvdr_index_t *I2, int addr1, int addr2, fpos_t *fpos );
extern void gvdr_uchdr ( gvdrcell_t *C );

#else /* __STDC__ */

extern void gvdr_clear (/* gvdrcell_t *C */);
extern void gvdr_free (/* gvdrcell_t *C */);
extern int gvdr_mradf (/* char **src, gvdradf_t *gadf, int Nadf */);
extern int gvdr_mranf (/* char **src, gvdranf_t *ganf, int Nanf, int Nsig0 */);
extern int gvdr_mrcell (/* char **src, gvdrcell_t *C */);
extern int gvdr_mredf (/* char **src, gvdredf_t *gedf, int Nedf */);
extern int gvdr_mrxif (/* char **src, gvdrxif_t *gxif, int Nxif */);
extern int gvdr_parsehdr (/* gvdrhdr_t *hdr */);
extern int gvdr_pcell (/* FILE *fp, gvdrcell_t *C */);
extern char * gvdr_proc_time (/* void */);
extern int gvdr_psize (/* FILE *fp, gvdrcell_t *C */);
extern int gvdr_rcell (/* FILE *fp, gvdrcell_t *C */);
extern void gvdr_realloc (/* gvdrcell_t *C, int NAxif, int NAedf, int NAadf, int NAanf, int NAsig0, int NAfit */);
extern void gvdr_reset (/* gvdrcell_t *C */);
extern int gvdr_rhdr (/* FILE *fp, gvdrhdr_t *hdr */);
extern int gvdr_rihdr (/* FILE *fp, int *len, fpos_t *iposp */);
extern int gvdr_rlhdr (/* FILE *fp, int *len */);
extern int gvdr_rpad (/* FILE *fp, unsigned int mult, char pad, fpos_t *fposp */);
extern int gvdr_rtrl (/* FILE *fp */);
extern int gvdr_seek1 (/* FILE *fp, gvdr_index_t *I, int addr, fpos_t *fpos */);
extern int gvdr_seek2 (/* FILE *fp, gvdr_index_t *I1, gvdr_index_t *I2, int addr1, int addr2, fpos_t *fpos */);
extern void gvdr_uchdr (/* gvdrcell_t *C */);

#endif /* __STDC__ */
#endif /* gvdr_H */
#endif /* GVDR_C */
