/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
static char rcsid[]="$Id: gvptest.c,v 1.3 1994/05/13 01:51:43 maurer Exp $";
/******************************************************************************
  gvptest.c

     Function:

This file is part of the STARLab Magellan Altimeter Data Processing Software.
Michael Maurer, March 1994.
******************************************************************************/
/* $Log: gvptest.c,v $
 * Revision 1.3  1994/05/13  01:51:43  maurer
 * Replaced calls to fopen() with calls to gvfopen().
 *
 * Revision 1.2  1994/05/11  04:54:24  maurer
 * Fixed silly bug that didn't initialize txo,tyo.
 *
 * Revision 1.1  1994/05/11  00:14:34  maurer
 * Removed pdstable_printrow() from program.
 *
 * Revision 1.0  1994/04/29  02:07:28  maurer
 * Initial revision
 * */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libmisc.h"
#include "gvdr.h"
#include "pdstab.h"
#include "gvpdstab.h"	/* for pt_gvhdr and gvpdslib.p */
#include "gcvt.h"
#include "proj.h"	/* for gv_proj.p */

#define GVPDSTEST_C
#include "gvptest.p"
#include "gvpdslib.p"
#include "pdstab.p"
#include "gvdr.p"
#include "gcvt.p"
#include "gv_proj.p"

int
main(int argc,
     char *argv[])
{
   FILE *fp;
   char *p;
   gvhdr_t gvh;
   gvdrhdr_t hdr;
   gvdrcell_t gv;
   gpds_tidx_t *tidx;
   gpds_pidx_t *pidx;
   gvdrxif_rec *xif;
   gvdredf_rec *edf;
   gvdradf_rec *adf;
   void *anf;
   proj_t P;

   printf("reading header in GVHDR\n");
   if ((fp=gvfopen(p="GVHDR.TAB","r"))==NULL)
      error(-1,errno,"[main] gvfopen %s failed",p);
   if (gvhdr_read(fp,&gvh))
      error(-1,0,"[main] gvhdr_read failed");
   fclose(fp);
   gcvt_setmode(GCVT_READ,gvh.gvh_fmt_float,gvh.gvh_fmt_byte);
   gvdrhdr_fill(&gvh,&hdr);
   if (gvdr_rproj(&hdr.hdr3,&P))
      error(-1,0,"[main] gvdr_rproj failed");

   printf("reading index in GVTIDX\n");
   tidx=gvtidx_alloc(&gvh);
   if ((fp=gvfopen(p="GVTIDX.TAB","r"))==NULL)
      error(-1,errno,"[main] gvfopen %s failed",p);
   if (gvtidx_read(fp,&gvh,tidx))
      error(-1,0,"[main] gvtidx_read failed");
   fclose(fp);
	       
   printf("allocating arrays\n");
   pidx=gvpidx_alloc(&gvh);
   xif=gvxif_alloc(&gvh);
   edf=gvedf_alloc(&gvh);
   adf=gvadf_alloc(&gvh);
   anf=gvanf_alloc(&gvh);
   gvpds_alloc(&gvh,&gv);
   while (1) {
      int x,y,tx,ty,px,py;
      static int txo = -1, tyo = -1;
      printf("enter pixel coords: ");
      scanf("%d %d",&x,&y);
      gvpds_p2t(&gvh,x,y,&tx,&ty,&px,&py);
      printf("converted coords to tile (%d,%d) pixel (%d,%d)\n",
	     tx,ty,px,py);
      
      if (tx!=txo || ty!=tyo) {
	 printf("reading tile from PIDX\n");
	 if ((fp=gvfopen(p="GVPIDX.TAB","r"))==NULL)
	    error(-1,errno,"[main] gvfopen %s failed",p);
	 if (gvpidx_rtile(fp,&gvh,tidx,tx,ty,pidx))
	    error(-1,0,"[main] gvpidx_rtile failed");
	 fclose(fp);

	 printf("reading tile from XIF\n");
	 if ((fp=gvfopen(p="GVXIF.TAB","r"))==NULL)
	    error(-1,errno,"[main] gvfopen %s failed",p);
	 if (gvxif_rtile(fp,&gvh,tidx,tx,ty,xif))
	    error(-1,0,"[main] gvxif_rtile failed");
	 fclose(fp);

	 printf("reading tile from EDF\n");
	 if ((fp=gvfopen(p="GVRDF.TAB","r"))==NULL)
	    error(-1,errno,"[main] gvfopen %s failed",p);
	 if (gvedf_rtile(fp,&gvh,tidx,tx,ty,edf))
	    error(-1,0,"[main] gvedf_rtile failed");
	 fclose(fp);

	 printf("reading tile from ADF\n");
	 if ((fp=gvfopen(p="GVADF.TAB","r"))==NULL)
	    error(-1,errno,"[main] gvfopen %s failed",p);
	 if (gvadf_rtile(fp,&gvh,tidx,tx,ty,adf))
	    error(-1,0,"[main] gvadf_rtile failed");
	 fclose(fp);

	 printf("reading tile from ANF\n");
	 if ((fp=gvfopen(p="GVANF.TAB","r"))==NULL)
	    error(-1,errno,"[main] gvfopen %s failed",p);
	 if (gvanf_rtile(fp,&gvh,tidx,tx,ty,anf))
	    error(-1,0,"[main] gvanf_rtile failed");
	 fclose(fp);
      }
      
      printf("converting pixel (%d,%d)\n",px,py);
      if (gvpds_rpixel(&gvh,pidx,xif,edf,adf,anf,px,py,&gv))
	 error(-1,0,"[main] gvpds_rpixel failed");
      
      gvpds_t2p(&gvh,tx,ty,px,py,&x,&y);
      gv.gv_X=x;
      gv.gv_Y=y;
      gvdr_tolat(&P,&gv);

      gvdr_pcell(stdout,&gv);
      txo=tx; tyo=ty;
   }
   return 0;
}
