/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
static char rcsid[]="$Id: pdstab.c,v 1.0 1994/04/29 02:07:46 maurer Exp $";
/******************************************************************************
  pdstab.c

     Function:  Read PDS format tables in GVDR.

This file is part of the STARLab Magellan Altimeter Data Processing Software.
Michael Maurer, March 1994.
******************************************************************************/
/* $Log: pdstab.c,v $
 * Revision 1.0  1994/04/29  02:07:46  maurer
 * Initial revision
 * */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libmisc.h"
#include "gpds.h"
#include "pdstab.h"

#define PDSTAB_C
#include "gpds.p"
#include "pdstab.p"

static int
pdstable_read1(char *s,
	       pdstable_t *pt,
	       void *p)
{
   int nf;

   p=(char *)p + pt->offset;
   nf=sscanf(s,pt->rfmt,p);
   if (nf==EOF || nf<1)
      return 2;
   return 0;
}

/******************************************************************************
  pdstable_readrow

Reads a single row of an ASCII PDS table from file fp, using data
structure pt to describe the table.  Pointer p points to the data
structure that will be filled by the row of the table.  Returns nonzero
on failure.
******************************************************************************/

int
pdstable_readrow(FILE *fp,
		 pdstable_t *pt,
		 void *p)
{
   static char buf[8192];
   char *s;

   if (fgets(buf,sizeof(buf),fp)==NULL)
      return 1;
   if (strlen(buf) >= sizeof(buf)-1)
      return 2;
   s=strtok(buf,",\r\n");
   while (pt && pt->name && s) {
      if (pdstable_read1(s,pt,p))
	 return 3;
      s=strtok(NULL,",\r\n");
      pt++;
   }
   if (pt->name)
      return 4;
   return 0;
}

