/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
/******************************************************************************
  pdstab.h

This file is part of the STARLab Magellan Altimeter Data Processing Software.
Michael Maurer, March 1994.
******************************************************************************/
/* $Log: pdstab.h,v $
 * Revision 1.0  1994/04/29  02:07:54  maurer
 * Initial revision
 * */

#ifndef PDSTAB_H
#define PDSTAB_H

#include <stddef.h>	/* for size_t */

typedef enum {
   T_UCHAR,T_USHORT,T_UINT,T_ULONG,
   T_CHAR,T_SHORT,T_INT,T_LONG,
   T_FLOAT,T_DOUBLE,T_STRING
} type_t;

typedef struct {
   char		*name;
   char		*wfmt;
   char		*rfmt;
   type_t	type;
   size_t	offset;
   int		start;
   int		bytes;
} pdstable_t;

typedef struct {
   char		*name;
   char		*subname;
   type_t	type;
   size_t	offset;
} pdssub_t;

#endif /* PDSTAB_H */
