/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
/******************************************************************************
  proj.h

This file is part of the STARLab Magellan Altimeter Data Processing Software.
Michael Maurer, May 1993.
******************************************************************************/
/* $Log: proj.h,v $
 * Revision 1.2  1993/12/22  00:21:05  maurer
 * Moved portions to wproj.h.
 *
 * Revision 1.1  1993/11/19  01:42:02  maurer
 * Changed the number of footprints fields from int to ushort.
 * Added optional longitude, latitude and user data fields to each pixel.
 * Added USGS module ID number to proj_t.
 * Added PROJ_NEIGHBOR macro.
 *
 * Revision 1.0  1993/06/12  00:39:23  maurer
 * Initial revision
 * */

#ifndef PROJ_H
#define PROJ_H

/* define map projections, supported or not (taken from P. Ford's GIPS source) */
typedef enum {
   pjTiepoint,
   pjGnomonic,
   pjStereographic,
   pjOrthographic,
   pjEquidistant,
   pjEquivalent,
   pjLambertConic1,
   pjLambertConic2,
   pjMercator,
   pjPolarStereo,
   pjMollweide,
   pjAlbers1,
   pjAlbers2,
   pjLambertCylindrical,
   pjLambertPolar,
   pjBonne,
   pjSinusoidal,
   pjWerner,
   pjUserDefined,
   pjAitoff,
   pjHammer,
   pjBriesemeister,
   pjCylindrical,
   pjNone
} proj_id;

/* some projections also need to specify a planet region or hemisphere: */
typedef enum {
   hmGlobal,
   hmEquat,
   hmNorth,
   hmSouth,
   hmEast,
   hmWest,
   hmNone
} hemi_id;

/* single pixel (cell) in a GIDX projection */
typedef struct {
   unsigned short	Nf;		/* # of footprints in f */
   unsigned short	Nal;		/* memory alloc size of f */
   void			*f;		/* data array (usually footprints of type foot_t) */
} projpix_t;

/* single line of pixels in GIDX projection */
typedef struct {
   int		reclen;			/* length of line after header */
   int		line;			/* this line's index number */
   int		pixlo;			/* index of first pixel in line */
   int		pixhi;			/* index of last pixel in line, >pixlo */
   projpix_t	*pix;			/* array of pixels */
   double	*lon;			/* optional longitude array */
   double	*lat;			/* optional latitude array */
   void		*user;			/* optional extra array */
} projlin_t;

/* projection parameters specify the details of the map projection */
typedef struct {
   double	eradius;
   double	pradius;
   double	xpixsiz;
   double	ypixsiz;
   double	lon0;
   double	lon1;
   double	lon2;
   double	lat0;
   double	lat1;
   double	lat2;
   double	x0;
   double	y0;
   double	lonlo;
   double	lonhi;
   double	latlo;
   double	lathi;
} projpar_t;

/* complete GIDX projection specification and data storage */
typedef struct {
   proj_id	proj;			/* projection type */
   hemi_id	hemi;
   int		linlo;			/* index of first line in projection */
   int		linhi;			/* index of last line in projection,>linlo */
   projpar_t	par;			/* projection parameters */
   int		usgs_id;		/* USGS proj  */
   projlin_t	*lin;			/* array of lines (where data is) */
} proj_t;

#endif /* PROJ_H */
