/*
 *  GVDR library for reading GVDR data files
 *  Copyright (C) 1994 Michael J. Maurer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Michael Maurer <maurer@nova.stanford.edu>
 *  Durand Bldg - Room 232
 *  Stanford, CA 94305-4055
 *  (415) 723-1024
 */
/******************************************************************************
  sfdug.h

This file is part of the STARLab Magellan Altimeter Data Processing Software.
Michael Maurer, May 1993.

Many of the comments are due to Peter Ford's mgm.h 1.13 4/10/90.
******************************************************************************/
/* $Log: sfdug.h,v $
 * Revision 1.0  1993/06/12  00:39:34  maurer
 * Initial revision
 * */

#ifndef SFDUG_H
#define SFDUG_H

/* codes for sfdu_t field 'vers' */
#define VERS_ASCII      '1'             /* ASCII length field */
#define VERS_BINARY     '2'             /* Binary length field */

typedef	struct {			/* based on mgm.h 1.13 4/10/90 */
   char			ctrl[4];	/* Control authority */
   char			vers;		/* 1/2=ASCII/binary */
   char			class;		/* SFDU type */
   char			spare[2];	/* Spares: 00 */
   char			ddid[4];	/* Data definition ID */
   union {
      char		alen[8];	/* ASCII aggregate length */
      unsigned char	blen[8];	/* Binary integer aggregate length */
   } length;
} sfdu_t;

typedef struct {
   char	*key;
   char *val;
} keyval_t;

typedef struct {
   char	*name;
   int	flag;
   char *fmt;
   char *val;
} keycat_t;

#define K_NUL		0
#define K_CON		1
#define K_PTR		2
#define K_MAL		3
#define K_FMT		4

#endif /* SFDUG_H */
