/*---------------------------------------------------------------*/
/*   Copyright (c) 1990 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)dfs_buffer.h	1.4    (UCLA/IGPP)    28 Jul 1994
*/
/*-------------------------------------------------------------
   Definitions for use with the Data Flow Systems buffered
   records functions.

   Development History:
       Begun: 10/18/90 - Todd King
--------------------------------------------------------------------*/

#ifndef _dfs_buffer_h_
#define _dfs_buffer_h_	1

#include <stdio.h>	/* For NULL */
#include "specialc.h"	/* For TRUE and FALSE */

typedef struct {
   int recl;		/* Length of a record */
   int max_recs;	/* Maximum number of records in buffer */
   int nrecs;		/* Number of records currently in the buffer */
   int first_rec;       /* First (oldest) record in buffer */
   int cur_rec;		/* Current working record */
   char *raw;		/* Raw data area */
} DFS_RECBUFF;

DFS_RECBUFF *dfs_make_buffer();

#endif /* _dfs_buffer_h_ */
