/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA, IGPP)    %G%
*/
/*-------------------------------------------------------------
  Definitions for flatfile I/O.

  Development History:
  Begun: 10/31/89 - Todd King
  Edited:09/20/93 - Gilbert Hyatt
         added iformation for COMPOUND file opens.
  Edited:04/14/93 - Gilbert Hyatt
	 added function prototypes.
--------------------------------------------------------------*/
#ifndef _FFIO_
#define _FFIO_	1

#include <stdio.h>
#include "sql.h"	   /* For SQL_FIELD */

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* Definitions for descriptors */

/* Maximum lengths */

#define FF_LNAME	32
#define FF_SNAME	 8
#define FF_UNITS	16
#define FF_TYPE		 1
#define FF_WIDTH	 3
#define FF_SORT		 2
/*                  --------      */
#define FF_DESCWIDTH	62 + sizeof('\n')

#define FF_MAX_ABS_LINE	80
#define FF_MAX_FIELD_WIDTH	999	/* Largest with 3 digits (FF_WIDTH) */

#define MAX_FILENAME	512

#define FF_HED_FNAME	8
#define FF_HED_PATH	36
#define FF_HED_CDATE	30	/* Must be at least 26 */
#define FF_HED_OWNER	20
#define FF_HED_NCOLS	3
#define FF_HED_NRECS	5

/* Definitions for working with flat files */

#define FF_FAILURE	0
#define FF_SUCCESS	1

/* Status field identifiers */

#define FF_DES	1
#define FF_DAT	2
#define FF_HED	4
#define FF_ABS	8
/*             --- */
#define FF_ALL	15	/* All components (sum of identifiers) */
#define FF_OPENED_BEFORE	16

/* Parameters for insert and delete variables */

#define FF_DELETE_INC	512	/* incriments delete lists are increased */
#define FF_INSERT_INC	512	/* incriments insert lists are increased */

/* Parameters for binding variables */

#define FF_BIND_INC	64  /* The step at which the bind list is increased */
#define FF_BIND_WRITE	1
#define FF_BIND_READ	2

/* Types used in the bind calls */
/* NOTE: Any time there are additions or subtractions from this
	 list the function ffcheck_type() must be updated.
*/
#define FF_INT		'I'
#define FF_FLOAT	'R'
#define FF_DOUBLE	'D'
#define FF_TIME		'T'
#define FF_ALPHA	'A'

/* Style of flatfile */
#define FF_STYLE_COMPONENT      1
#define FF_STYLE_VIRTUAL	2
#define FF_STYLE_COMPOUND	3

/* Type of flatfile */
#define FF_TYPE_HIGHER          1
#define FF_TYPE_LOWER           2
#define FF_TYPE_FLOWFILE        3


/* Identifier for virtual flatfiles */

#define FF_VIRTUAL_MAGIC_COOKIE "TYPE=UCLA/IGPP-VIRTUAL-FF-1.0\n"

/* Open style codes */

#define FF_OPEN_READ	1
#define FF_OPEN_WRITE	2
#define FF_OPEN_APPEND	3
#define FF_OPEN_UPDATE	4

typedef struct {
   unsigned long cnt;
   unsigned long max;
   unsigned long *recnum;
} FF_DELETE;

typedef struct {
   unsigned long recnum;
   char *data;
} FF_RECORD;

typedef struct {
   unsigned long cnt;
   unsigned long max;
   FF_RECORD *record;
} FF_INSERT;

typedef struct {
    char fname[FF_HED_FNAME];
    char path[FF_HED_PATH];
    char cdate[FF_HED_CDATE];
    char owner[FF_HED_OWNER];
    char ncols[FF_HED_NCOLS];
    char nrecs[FF_HED_NRECS];
} FF_HED_REC;

/* For application level definitions of descriptors */
typedef struct {
  char longname[FF_LNAME + 1];
  char shortname[FF_SNAME + 1];
  char units[FF_UNITS + 1];
  char type;
  unsigned int width;
  int  sort;
} FF_DESC;

/* For internal definitions of descriptors */
typedef struct _FF_FULL_DESC_ {
  char longname[FF_LNAME + 1];
  char shortname[FF_SNAME + 1];
  char units[FF_UNITS + 1];
  char type;
  unsigned int width;
  int  sort;
  unsigned long offset;
  struct _FF_FULL_DESC_ *next;
} FF_FULL_DESC;

typedef struct {
  char *vaddr;
  unsigned type;
  unsigned long cidx;
  unsigned long size;
} FF_BINDER;

typedef struct {
  FILE *fptr;
} VIRTUAL_INFO;

typedef struct {
  char *fname_list[MAX_FILENAME];
  int  numfiles;
  int  currentfile;
} COMPOUND_INFO;

typedef struct {
  int style;
  VIRTUAL_INFO  vinfo;
  FILE *desc;
  FILE *abs;
  FILE *hed;
  FILE *data;
  FF_FULL_DESC *descdb;
  unsigned long ncols;
  unsigned long reclen;
  unsigned long nrecs;
  unsigned long cur_recnum;
  unsigned int open_style;
  unsigned open_status;
  char *rec_buff;
  char fname[MAX_FILENAME + 1];
  unsigned flags;
  unsigned long bindcnt;
  unsigned long bindmax;
  FF_BINDER *bindlist;
  FF_DELETE dlist;
  FF_INSERT ilist;
  COMPOUND_INFO compound;
  int           type;
} FLATFILE;

typedef double TIME;

/* Macro functions */
#define ffclose(ffptr)	        ffclose_select(ffptr, FF_ALL)
#define ffwrite(s, n, t, f)     fwrite(s, n, t, f->data); f->nrecs += t
#define ffset_col_val(f, c, v)	_ffset_col_val(f, c, (double) v)

/* function prototypes */

/* ffadd_desc.c */
int ffadd_desc (FLATFILE *ffptr, FF_DESC desc[]);
/* ffbind.c */
int ffbind (FLATFILE *ffptr, unsigned int idx, char *var_addr, unsigned type, unsigned size);
/* ffbind_dfs_col.c */
int ffbind_dfs_col (FLATFILE *ffptr, unsigned int ff_idx, char df_sname[]);
/* ffbulk_write.c */
int ffbulk_write_fd (FLATFILE *ffptr, int fd);
int ffbulk_write_file (FLATFILE *ffptr, FILE *fptr);
/* ffcheck_type.c */
int ffcheck_type (unsigned type);
/* ffclose_sel.c */
int ffclose_select (FLATFILE *ffptr, unsigned int compon);
/* ffcol_type.c */
int ffcol_type (FLATFILE *ffptr, unsigned int idx);
/* ffcol_lname.c */
char *ffcol_lname (FLATFILE *ffptr, unsigned int idx);
/* ffcol_sname.c */
char *ffcol_sname (FLATFILE *ffptr, unsigned int idx);
/* ffcol_units.c */
char *ffcol_units (FLATFILE *ffptr, unsigned int idx);
/* ffcolparse.c */
int ffcolparse (FLATFILE *ffptr, char colstring[], char *colarray[], int maxarray, int duplicates_allowed);
/* ffcol_width.c */
int ffcol_width (FLATFILE *ffptr, unsigned int idx);
/* ffcreate.c */
FLATFILE *ffcreate (char name[], FF_DESC *desc, char *abs[], int make_path, int overwrite);
/* ffdelete_rec.c */
int ffdelete_rec (FLATFILE *ffptr);
/* ffdo_bind.c */
int ffdo_bind (FLATFILE *ffptr, unsigned direction);
/* ffexists.c */
int ffexists (char name[]);
/* ffflag_rec.c */
int ffflag_rec (FLATFILE *ffptr);
/* ffget_col_str.c */
char *ffget_col_str (FLATFILE *ffptr, unsigned long idx);
/* ffget_col_val.c */
double ffget_col_val (FLATFILE *ffptr, unsigned long idx);
/* ffget_desc.c */
FF_FULL_DESC *ffget_desc (FLATFILE *ffptr, unsigned int idx);
/* ffinsert_rec.c */
int ffinsert_rec (FLATFILE *ffptr);
/* ffisflag.c */
int ffisflag (FLATFILE *ffptr, int idx);
/* ffmake_path.c */
int ffmake_path (char path[]);
/* ffmake_dfs_col.c */
int ffdup_flow_col (FLATFILE *ffptr, char sname[], char fflname[], char ffsname[]);
/* ffmakedesc.c */
int ffmakedesc (FLATFILE *ffptr, char longname[32  + 1], char shortname[ 8  + 1], char units[16  + 1], int type, unsigned int width, int sort);
/* ffmove_bin.c */
int ffmove_bin (FLATFILE *ffptr, unsigned long cidx, double value);
/* ffmove_rel.c */
int ffmove_rel_rec (FLATFILE *ffptr, long nrecs);
/* ffmove_to.c */
int ffmove_to_rec (FLATFILE *ffptr, unsigned long recnum);
/* ffncol.c */
int ffncol (FLATFILE *ffptr);
/* ffopen.c */
FLATFILE *ffopen (char basename[], char option[]);
/* ffopen_seg.c */
int ffopen_segment (FLATFILE *ffptr);
/* ffopen_select.c */
FLATFILE *ffopen_select (FLATFILE *ffptr, char option[], unsigned int compon);
/* lffopen_select.c */
FLATFILE *lffopen_select (FLATFILE *ffptr, char option[], unsigned int compon);
int segment (char *instr, char *outstr, int start, int end);
int insert (char *instr, char *ins, int start, int end);
int valid_type (int c);
/* nffopen_select.c */
FLATFILE *nffopen_select (FLATFILE *ffptr, char option[], unsigned int compon);
/* ffpad_str.c */
int ffpad_str (char str[], int pchar, int to);
/* ffprint_rec.c */
int ffprint_rec (FLATFILE *ffptr);
/* ffread_abs.c */
int ffread_abs (FLATFILE *ffptr, char *abs_lines[], unsigned long max_lines);
/* ffread_rec.c */
int ffread_rec (FLATFILE *ffptr);
/* ffscol_index.c */
int ffscol_index (FLATFILE *ffptr, char sname[], unsigned int *cidx);
/* ffread_scalar.c */
int ffread_scalar (FLATFILE *ffptr, char *column, SQL_SCALAR *scalar);
/* ffset_col_flag.c */
int ffset_col_flag (FLATFILE *ffptr, int idx);
/* ffset_col_str.c */
int ffset_col_str (FLATFILE *ffptr, unsigned long idx, char svalue[]);
/* ffset_col_val.c */
int _ffset_col_val (FLATFILE *ffptr, unsigned long idx, double value);
/* ffsql.c */
int ffSQLReadScalar (FLATFILE *ffptr, char *column, SQL_SCALAR *scalar);
SQL_FIELD *ffSQLFieldName (SQL_FIELD *field, LIST_NODE *df_list);
/* ffupdate.c */
int ffupdate (FLATFILE *ffptr);
/* ffunlink.c */
int ffunlink (char name[]);
/* ffwrite_abs.c */
int ffwrite_abs (FLATFILE *ffptr, char *abs[]);
/* ffwrite_desc.c */
int ffwrite_desc (FLATFILE *ffptr);
/* ffwrite_hed.c */
int ffwrite_hed (FLATFILE *ffptr);
/* ffwrite_rec.c */
int ffwrite_rec (FLATFILE *ffptr);
/* ffcompare.c */
int ffcompare (FLATFILE *ffptr1, FLATFILE *ffptr2, int checksort);
/* ffopen_cseg.c */
int ffopen_csegment (FLATFILE *ffptr);
/* ffget_dfs_desc.c */
FF_DESC *ffget_dfs_desc (char df_sname[]);
/* ffcomparedf.c */
int ffcomparedf (FLATFILE *ffptr);

#endif /* _FFIO_ */
