/*----------------------------------------------------------------
   Copyright (c) 1992 Regents of the University of California
                 All Rights Reserved

   Development History:
      Begun: 12/02/91 - Todd King
      Edited:04/14/94 - Gilbert Hyatt
	Added function Prototyes.

   Version:
      @(#)list.h	1.6   (UCLA/IGPP)   28 Jul 1994
------------------------------------------------------------------*/
#ifndef _list_h_
#define _list_h_	1

typedef struct LIST_NODE {
   char *id;
   char *data;
   struct LIST_NODE *next;
} LIST_NODE;

/* function Prototype */

/* dump.c */
int list_dump (LIST_NODE *list);
/* find_node.c */
LIST_NODE *list_find_node (LIST_NODE *list, char id[]);
/* free_node.c */
int list_free_node (LIST_NODE *node);
/* free.c */
int list_free (LIST_NODE *node);
/* get_data.c */
char *list_get_data (LIST_NODE *node);
/* insert_node.c */
LIST_NODE *list_insert_node (LIST_NODE *parent, LIST_NODE *node);
/* make_node.c */
LIST_NODE *list_make_node (char id[]);
/* push_node.c */
LIST_NODE *list_push_node (LIST_NODE *head, LIST_NODE *node);
/* set_data.c */
int list_set_data (LIST_NODE *node, char *datap);
/* free_node.c */
int list_free_node (LIST_NODE *node);
/* pop_node.c */
LIST_NODE *list_pop_node (LIST_NODE *head);

#endif /* _list_h_ */
