/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
         @(#)miscc.h	1.10     (UCLA/IGPP)    28 Jul 1994
 */
/* Defines those parameters needed for use with the functions    */
/* in the library 'miscc'. Also defines the return value for     */
/* functions which return something other then the default value */
/*                                                               */
/* Begun: 3/02/87 - Todd King                                    */
/* Edit : 7/23/93 - Gilbert Hyatt                                */
/* Edited:4/14/94 - Gilbert Hyatt added function prototypes      */
#ifndef _MISCC_H_
#define _MISCC_H_

#include <stdio.h>	/* For FILE */

#define Nulllist (char **)0
#define IO_READ      0
#define IO_WRITE     1
#define IO_ERROR     2

#define IO_2_PROGRAM 0
#define IO_2_STDIN   0
#define IO_2_STDOUT  1
#define IO_2_NULL    2
#define IO_2_FILE    3

#include "vars.h"

/* function prototypes */

/* allocstr.c */
char *allocstr (char *in_ptr);
/* can_execute.c */
int can_execute (char fname[]);
/* can_read.c */
int can_read (char fname[]);
/* copylist.c */
char **copylist (int cnt, char *list[]);
/* def_home_dir.c */
int def_home_dir (char *name, char *hdir);
/* dir.c */
int dir (char pathmask[], char *dirlist[], int (*sorter)());
/* editor.c */
int find_editor (char *editor_name);
/* filetype.c */
int filetype (char *fs);
/* findfile.c */
int findfile (char *fname, char *pathlist[], char *found_name, int ftype);
/* freelist.c */
int freelist (int cnt, char **list);
/* fsize.c */
long fsize (char filename[]);
/* helpc.c */
int help (char keyword[], char libname[], char *pathlist[]);
struct lib_entry *libentry (char fullpath[], char keyword[]);
/* home_dir.c */
char *home_dir (void);
/* in_directory.c */
int in_directory (char file_name[], char dir_name[]);
/* match.c */
int match (char *mask, char *string);
/* matchfile.c */
int matchfile (char *filename, unsigned int flags);
/* readinit.c */
int readinit (char initfile[], VAR_STRUCT_PTR *sublist, int (*cmdfunc)());
/* setmask.c */
int setmask (char *mask);
/* start_more.c */
int start_more (FILE **more_ptr);
/* strip_ext.c */
char *strip_extension (char *pathname);
/* strip_path.c */
char *strip_path (char *pathname);
/* dfsMessage.c */
int dfsMessage (char *message[], int severity, int exit_code);
/* TestFdReady.c */
int TestFdReady (int fd, int request);
/* TokenStuff.c */
char *GetLine (FILE *fptr, int len);
char *TokenValue (FILE *fptr, char *searchtoken, int len);
char *TokenValueBeforeToken (FILE *fptr, char *searchtoken, int len, char *beforetoken);
int TokenValueEqual (FILE *fptr, char *token, char *invalue);
/* TwoWayPopen.c */
int *TwoWayPopen (char *command, int outputTo, char *outputFile);
/* SigMsg.c */
char *SigMsg (int smsg);
void Assign (char *signalMsg[]);
/* GetEnvOrDef.c */
char *GetEnvOrDef (char *envVar, char *fallBack);
/* VarStrStruff.c */
char *VarStrDup (char *start, ...);
char *VarStrCpy (char *results, ...);
/* infinity.c */
double infinity (void);

#endif /* _MISCC_H_ */
