/*----------------------------------------------------------------
   Definitions for use with the pattern matching functions.

   Development History:
      Begun: 03/02/92 - Todd King
      Edited:04/14/94 - Gilbert Hyatt
      	prototypes for function moved to parserc.h

   Version:
      @(#)pattern.h	1.6    (UCLA/IGPP)   28 Jul 1994
------------------------------------------------------------------*/
#ifndef pattern_h
#define pattern_h	1

#include <stddef.h>	/* For NULL */
#include "abbrev.h"     /* for AbbrevPushNode, for function prototypes */
#include <stdio.h>      /* for FILE* defination */

/* Type definitions */

typedef struct PATTERN {
   int type;			/* Type of this token */
   char *text;			/* Text to match (FIXED token only) */
   unsigned int text_len;	/* Length of text */
   struct PATTERN *next;	/* Next token in list */
} PATTERN;

/* PAttern token types */

#define PATTERN_TYPE_SINGLE_CHAR	1
#define PATTERN_TYPE_MULTIPLE_CHAR	2
#define PATTERN_TYPE_FIXED		3

#include "parserc.h"

#endif /* pattern_h */
