/*----------------------------------------------------------------
   Copyright (c) 1992 Regents of the University of California
                 All Rights Reserved

   Development History:
      Begun: 12/02/91 - Todd King
      Edited:04/14/94 - Gilbert Hyatt
	added function prototypes.

   Version:
      @(#)sql.h	1.6   (UCLA/IGPP)   28 Jul 1994
------------------------------------------------------------------*/
/*------------------------------------------------------------
   Structures for compiling SQL queries.
------------------------------------------------------------*/

#ifndef _sql_h_
#define _sql_h_	1

#include "list.h"
#include "pattern.h"

enum { SQL_FUZZY_PLUS = 1, SQL_FUZZY_MINUS, SQL_FUZZY_PLUS_MINUS};

typedef struct SQL_LIST {
   char *text;
   struct SQL_LIST *next;
} SQL_LIST;

typedef struct SQL_TABLE {
   char *name;
   SQL_LIST *fields;
   struct SQL_TABLE *next;
} SQL_TABLE;

typedef struct SQL_FIELD {
   char *table;
   char *column;
   struct SQL_FIELD *next;
} SQL_FIELD;

typedef struct SQL_SCALAR {
   int type;
   SQL_FIELD *field;
   int ival;
   double dval;
   char *text;
   PATTERN *pattern;
   struct SQL_SCALAR *fuzzy_plus;
   struct SQL_SCALAR *fuzzy_minus;
} SQL_SCALAR;

typedef struct SQL_ALIAS {
   char *text;
   char *alias;
   struct SQL_ALIAS *next;
} SQL_ALIAS;

typedef struct SQL_ASSIGNMENT{
   char *field;
   SQL_SCALAR *scalar;
   struct SQL_ASSIGNMENT *next;
} SQL_ASSIGNMENT;

typedef struct SQL_VALUE {
   SQL_SCALAR *value;
   struct SQL_VALUE *next;
} SQL_VALUE;

typedef struct SQL_QUERY {
   int action;
   char *table;
   SQL_FIELD *field;
   SQL_ALIAS *alias;
   SQL_VALUE *value;
   LIST_NODE *constraint;
   SQL_ASSIGNMENT *assignment;
} SQL_QUERY;

typedef struct SQL_VIEWS {
   SQL_TABLE *tables;
   SQL_QUERY *query;
} SQL_VIEWS;

/* External global definitions */
extern SQL_FIELD *SQL_field_list;       /* Defined in "sql_field.c" */
extern SQL_FIELD *SQL_last_field;       /* Defined in "sql_field.c" */
 
extern SQL_ALIAS *SQL_alias_list;       /* Defined in "sql_alias.c" */
extern SQL_ALIAS *SQL_last_alias;       /* Defined in "sql_alias.c" */
  
extern LIST_NODE *SQL_constraint_list;     /* Def in "sql_parser.y" */
   
extern SQL_VALUE *SQL_value_list;     /* Def in "sql_value.c" */
extern SQL_VALUE *SQL_last_value;     /* Def in "sql_value.c" */
   
extern SQL_ASSIGNMENT *SQL_assignment_list;     /* Def in "sql_assignment.c" */
extern SQL_ASSIGNMENT *SQL_last_assignment;     /* Def in "sql_assignment.c" */
    
extern SQL_QUERY *SQL_query;            /* Defined in "sql_query.c" */

/* Action codes */
#define SQL_ACTION_SELECT 1
#define SQL_ACTION_INSERT 2
#define SQL_ACTION_UPDATE 3
#define SQL_ACTION_DELETE 4

/* Operator codes */

#define SQL_OP_PLUS		1
#define SQL_OP_MINUS		2
#define SQL_OP_MULT		3
#define SQL_OP_DIV		4
#define SQL_OP_AND		5
#define SQL_OP_OR		6
#define SQL_OP_BETWEEN		7
#define SQL_OP_NOT		8
#define SQL_OP_GREATER_THAN	9
#define SQL_OP_LESS_THAN	10
#define SQL_OP_NOT_EQUAL	11
#define SQL_OP_EQUAL		12
#define SQL_OP_GREATER_EQUAL	13
#define SQL_OP_LESS_EQUAL	14

/* Type codes for scalar values */

#define SQL_TYPE_FIELD		1
#define SQL_TYPE_FUNCTION	2
#define SQL_TYPE_INT		3
#define SQL_TYPE_DOUBLE		4
#define SQL_TYPE_TEXT		5
#define SQL_TYPE_DATE_TIME	6
#define SQL_TYPE_OPERATOR	7

/* function prototypes */

/* sql_parser.c */
int dump_scalar_list (LIST_NODE *list);
/* sql_lex.c */
int set_query (char *text);
/* sql_field.c */
SQL_FIELD *sql_make_field (void);
int sql_free_field (SQL_FIELD *field);
SQL_FIELD *sql_last_field (SQL_FIELD *list);
SQL_FIELD *sql_push_field (SQL_FIELD *list, SQL_FIELD *field);
int sql_dump_field (SQL_FIELD *field);
/* sql_alias.c */
SQL_ALIAS *sql_make_alias (void);
int sql_free_alias (SQL_ALIAS *alias);
int sql_push_alias (SQL_ALIAS *alias);
int sql_dump_alias (SQL_ALIAS *alias);
/* sql_assignment.c */
SQL_ASSIGNMENT *sql_make_assignment (void);
int sql_free_assignment (SQL_ASSIGNMENT *assignment);
int sql_push_assignment (SQL_ASSIGNMENT *assignment);
int sql_dump_assignment (SQL_ASSIGNMENT *assignment);
/* sql_semantics.c */
int sql_patch (SQL_QUERY *query);
int sql_redo_field_list (SQL_QUERY *query, LIST_NODE *df_list, SQL_FIELD *(*field_name)());
SQL_VIEWS *sql_build_views (SQL_QUERY *query);
/* sql_query.c */
SQL_VIEWS *sql_parse_query (char *query);
SQL_VIEWS *sql_make_views (void);
int sql_free_views (SQL_VIEWS *views);
SQL_QUERY *sql_make_query (void);
int sql_free_query (SQL_QUERY *query);
int sql_dump_query (SQL_QUERY *query);
int sql_dump_action (int action);
/* sql_scalar.c */
SQL_SCALAR *sql_make_scalar (void);
int sql_free_scalar (SQL_SCALAR *scalar);
int sql_copy_scalar (SQL_SCALAR *s1, SQL_SCALAR *s2);
int sql_define_scalar (SQL_SCALAR *sptr, int type, ...);
int sql_dump_scalar (SQL_SCALAR *scalar);
int sql_change_type_scalar (SQL_SCALAR *scalar, int type);
int sql_add_scalar (SQL_SCALAR *s1, SQL_SCALAR *s2);
int sql_sub_scalar (SQL_SCALAR *s1, SQL_SCALAR *s2);
int sql_add_factored_scalar (SQL_SCALAR *s1, SQL_SCALAR *s2, int factor);
int sql_mult_scalar (SQL_SCALAR *s1, SQL_SCALAR *s2);
int sql_div_scalar (SQL_SCALAR *s1, SQL_SCALAR *s2);
int sql_mult_factored_scalar (SQL_SCALAR *s1, SQL_SCALAR *s2, int factor);
int sql_compare_scalar (SQL_SCALAR *s1, SQL_SCALAR *s2, int relop);
int sql_compare_fuzzy_scalar (SQL_SCALAR *s1, SQL_SCALAR *s2, int relop);
int sql_compare_static_scalar (SQL_SCALAR *s1, SQL_SCALAR *s2, int relop);
LIST_NODE *sql_make_scalar_node (int type, ...);
int sql_dump_scalar_list (LIST_NODE *list);
/* sql_list.c */
SQL_LIST *sql_make_list (void);
int sql_free_list (SQL_LIST *list);
int sql_dump_list (SQL_LIST *list);
SQL_LIST *sql_push_list (SQL_LIST *head, SQL_LIST *child);
SQL_LIST *sql_find_list (SQL_LIST *head, char text[]);
/* sql_table.c */
SQL_TABLE *sql_make_table (void);
int sql_free_tables (SQL_TABLE *table);
int sql_dump_table (SQL_TABLE *table);
SQL_TABLE *sql_find_table (SQL_TABLE *head, char name[]);
SQL_TABLE *sql_push_table (SQL_TABLE *head, SQL_TABLE *child);
/* sql_value.c */
SQL_VALUE *sql_make_value (void);
int sql_free_value (SQL_VALUE *value);
int sql_push_value (SQL_VALUE *value);
int sql_dump_value (SQL_VALUE *value);
/* sql_constraint.c */
int sql_optimize_constraint (LIST_NODE *constraint);
int sql_eval_constraint (LIST_NODE *constraint, LIST_NODE *ff_list, int (*read_scalar)());


#endif /* _sql_h_ */
