/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)vars.h	1.4    (UCLA/IGPP)     28 Jul 1994
 */
#ifndef _VARS_
#define _VARS_
/* --------------------------------------------------------- */
/* INCLUDE FILE FOR STRING VARIABLE STORAGE.                 */
/*                                                           */
/* The data structure is a stack.  New commands are added    */
/* to the top of the stack (the front of the linked list).   */
/*                                                           */
/* To use these routines, declare a list as follows.         */
/* The variable name is arbitrary.                           */
/*    VAR_STRUCT_PTR L = NULL;                               */
/*                                                           */
/* Summary of functions:                                     */
/*   'Callable' functions:                                   */
/*     printvars(L) - prints all variables and values in L   */
/*          to stdout (actually is a defined psuedo-function)*/
/*     fprintvars(F, L) - prints all variables and values in */
/*          to the file pointed to by F.                     */
/*     setval(&L,var,equate) - sets var to equate.           */
/*     getval(L,var,equate) - equate set to value of var.    */
/*     defined(L,var) - returns 1 if var is defined.         */
/*     clearvars(&L) - clears all variable definitions.      */
/*                                                           */
/*   Internal functions:                                     */
/*     push(&L,var, equate) - adds pair to front of the list.*/
/*     var_addr(L,var) - address of structure containing var.*/
/*                                                           */
/*      Development History:                                 */
/*              Begun:  11/4/86 - Marco Zagha                */
/*              Update:  3/3/87 - Marco Zagha                */  
/*                The first version of the library used      */
/*                global lists.  All the routines were       */
/*                changed to take a list as a parameter so   */
/*                that more than one list may be maintained. */
/*              Update: 4/8/87 - Todd King                   */
/*                To add 'fprintvars' and convert 'printvars'*/
/*                to a define statement.                     */
/* --------------------------------------------------------- */
typedef struct var_struct VAR_STRUCT;
typedef VAR_STRUCT  *VAR_STRUCT_PTR;
struct var_struct {
		    char           *varname;
		    char           *value;
		    VAR_STRUCT_PTR  next;
		  };


VAR_STRUCT_PTR var_addr();

#define printvars(x)	fprintvars(stdout, x)
#endif /* _VARS_ */
