/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
*/
/*-- ffbulk_write_fd ----------------------------------------------------
  Copies the content of a flatfile from the current possition
  in the flatfile to the end to the designated file descriptor.
  Returns FF_SUCCESS upon successful completion or FF_FAILURE
  upon error or encountering the end of file.

   Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )
    fd   : The file descriptor of a pre-opened file.
 
  Return Value:
     FF_SUCCESS: If the copy succeeded.
     FF_FAILURE: If the flatfile pointer is invalid, if the write
                 fails.

  Development History:
    Begun: 02/20/92 - Todd King
---------------------------------------------------------------------*/
#include "ffio.h"

int 
ffbulk_write_fd (FLATFILE *ffptr, int fd)
{
  char buffer[2048];	/* Arbitrary size */
  int cnt;
  int more = 1;

  if(ffptr == NULL) return(FF_FAILURE);

  while(more) {
     while((cnt = fread(buffer, 1, sizeof(buffer), ffptr->data)) > 0) {
	write(fd, buffer, cnt);
     } 
     if(ffptr->style == FF_STYLE_VIRTUAL) { /* See if another segment */ 
        if(ffopen_segment(ffptr) == FF_FAILURE) {
           more = 0;
        } 
     } else {
       more = 0;
     }
  }

  return(FF_SUCCESS);
}

/*-- ffbulk_write_file ----------------------------------------------------
  Copies the content of a flatfile from the current possition
  in the flatfile to the end to the designated file pointer.
  Returns FF_SUCCESS upon successful completion or FF_FAILURE
  upon error or encountering the end of file.

   Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )
    fptr : A FILE pointer to preopened file.
 
  Return Value:
     FF_SUCCESS: If the copy succeeded.
     FF_FAILURE: If the flatfile pointer is invalid, if the write
                 fails.

  Development History:
    Begun: 02/20/92 - Todd King
---------------------------------------------------------------------*/
#include "ffio.h"

ffbulk_write_file(ffptr, fptr)
FLATFILE *ffptr;
FILE *fptr;
{
  char buffer[2048];	/* Arbitrary size */
  int cnt;
  int more = 1;

  if(ffptr == NULL) return(FF_FAILURE);

  while(more) {
     while((cnt = fread(buffer, 1, sizeof(buffer), ffptr->data)) > 0) {
	fwrite(buffer, 1, cnt, fptr);
     } 
     if(ffptr->style == FF_STYLE_VIRTUAL) { /* See if another segment */ 
        if(ffopen_segment(ffptr) == FF_FAILURE) {
           more = 0;
        } 
     } else {
       more = 0;
     }
  }

  return(FF_SUCCESS);
}
