/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffdelete_rec ------------------------------------------
  Marks the current record for deletion. This adds the current
  record number ot a list. Actaul deletions occur when an ffupdate()
  is called.

  Entry Requirements:
     ffptr: A pointer to a flatfile (as returned from ffopen()).

  Return Value:
      FF_SUCCESS is the deletion was successful. FF_FAILURE if]
      the flatfile was opened for read or append or if ffptr is NULL.

  Development History:
     Begun: 1/14/92 - Todd King
-------------------------------------------------------------*/
#include <sys/types.h>
#include "ffio.h"

int 
ffdelete_rec (FLATFILE *ffptr)
{
   unsigned long need;
   unsigned long *iptr;

   if(ffptr == NULL) return(NULL);

   if(ffptr->open_style != FF_OPEN_UPDATE) return(FF_FAILURE);

   if(ffptr->ilist.cnt != 0) return(FF_FAILURE); /* can't intermix */

   if((ffptr->dlist.cnt  + 1) >= ffptr->dlist.max) {
      need = FF_DELETE_INC * 
	    (ffptr->dlist.cnt + FF_DELETE_INC) / FF_DELETE_INC;
      iptr = (unsigned long *)malloc(sizeof(unsigned long) * need);
      if(iptr == NULL) return(FF_FAILURE);
      ffptr->dlist.max = need;
      memcpy(iptr, ffptr->dlist.recnum,  
	    ffptr->dlist.cnt * sizeof(unsigned long));
      free(ffptr->dlist.recnum);
      ffptr->dlist.recnum = iptr;
   }
   ffptr->dlist.recnum[ffptr->dlist.cnt] = ffptr->cur_recnum - 1;
   ffptr->dlist.cnt++;

   return(FF_SUCCESS);
}

