/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffread_abs ---------------------------------------------------
  Reads the abstract file and places the lines into the passed
  array of string pointers. The maximum allowed length of a line 
  in the abstract is FF_MAX_ABS_LINE. The pointer
  into the abstract file is left at the end of the last
  line which has been read. Subsequent calls will begin reading
  at this point, so you can process the abstract file with subsequent
  calls.

  Entry Requirements:
     ffptr: A pointer to a flatfile.
     abs_lines: An array of character strings at least FF_MAX_ABS_LINE
	     in length.
     max_lines: The count of the number of elements in abs_lines.

  Return Value:
    The number of lines actually read.
    0 if end of file of error.

  Development History:
    Begun: 11/13/89 - Todd King
-----------------------------------------------------------------*/
#include "ffio.h"

int 
ffread_abs (FLATFILE *ffptr, char *abs_lines[], unsigned long max_lines)
{
  unsigned long i = 0;

  if(ffptr == NULL) return(0);

  for(i = 0; i < max_lines; i++) {
    if(fgets(abs_lines[i], FF_MAX_ABS_LINE, ffptr->abs) == NULL) {
      return(0);
    }
  }
  return(i);
}

