#include <stdio.h>
#include <string.h>
#include "miscc.h"

/*---------------------------------------------------------------*/
/*   Copyright (c) 1993 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
*/
/******************************************************************
*  Some Simple functions to parse a file that contains            *
*  TOKEN=VALUE file.                                              *
*                                                                 *
*  Began:  03-08-93 Gilbert F. Hyatt                              *
*  Cancat: 03-24-94 Gilbert F. Hyatt                              *
*  	Put all in one file.                                      *
*******************************************************************/
static char str[2048];

char*
GetLine(FILE *fptr, int  len)
{
  if (fptr == NULL)                        return(NULL);
  if (fgets(str, (len *2), fptr) == NULL)  return(NULL);
  TrimSpcLoc(str);
  if (strlen(str) > len) str[len] = '\0';
  return(str);
}  /* end of GetLine() */


  
char*
TokenValue(FILE *fptr, char *searchtoken, int  len)
{
  char *parts[10], *str;
  int  numparts;

  while((str = GetLine(fptr, 1000)) != NULL) {
    numparts = mop2(str, "*=*", parts);
    if (numparts < 2) continue;
    TrimSpcLoc(parts[0]);
    TrimSpcLoc(parts[1]);

    if (strcmp(searchtoken, parts[0]) != 0) continue;
    while((str = strchr(parts[1], '\'')) != NULL) *str = ' ';
    while((str = strchr(parts[1], '"'))  != NULL) *str = ' ';
    TrimSpcLoc(parts[1]);
    
    if (strlen(parts[1]) > len) parts[1][len] = '\0';

    return(strdup(parts[1]));
  }  /* end of while */

  return(NULL);
}  /* end of TokenValue() */



char*
TokenValueBeforeToken(FILE *fptr, char *searchtoken, int  len, char *beforetoken)
{
  char *parts[10], *str;
  int  numparts;

  while((str = GetLine(fptr, 1000)) != NULL) {
    numparts = mop2(str, "*=*", parts);
    if (numparts < 2) continue;
    TrimSpcLoc(parts[0]);
    TrimSpcLoc(parts[1]);

    if (strcmp(beforetoken, parts[0]) == 0) return(NULL);
    if (strcmp(searchtoken, parts[0]) != 0) continue;
    while((str = strchr(parts[1], '\'')) != NULL) *str = ' ';
    while((str = strchr(parts[1], '"'))  != NULL) *str = ' ';
    TrimSpcLoc(parts[1]);
    
    if (strlen(parts[1]) > len) parts[1][len] = '\0';

    return(strdup(parts[1]));
  }  /* end of while */

  return(NULL);
}  /* end of TokenValueBeforeToken() */



int
TokenValueEqual(FILE *fptr, char *token, char *invalue)
{
  char* returnval;

  while((returnval = TokenValue(fptr, token, (strlen(invalue) +3))) != NULL) {
    if (strcmp(returnval, invalue) == 0) {free(returnval); return(1);}
    free(returnval);
  }  /* end of while */

  return(0);
}  /* end of TokenValueEqual() */



/*-- TRIMSPC --------------------------------------*/
/* trims leading and trailing spaces from          */
/* a passed string.                                */
/* Considers tabs, space, newline, carriage return */
/* and formfeeds to be white space (per 'isspace') */
/*                                                 */
/*  Version:  Locate Copy.                         */
/*-------------------------------------------------*/
#include <ctype.h>

static 
TrimSpcLoc (char string[])
{
 int j,n,end;

  j=strlen(string)-1;  /* First xter in string */
  while(isspace(string[j]) && j > 0) j--;  /* trim trailing spaces */
  string[j+1]='\0'; /* truncate */
  j=0;  /* preset */
  while(isspace(string[j]) && string[j] != '\0') j++; /* trim leading spaces */
  if(j>0)  /* shift string left */
  {
    end=strlen(string);
    for(n=0;n<end;n++) string[n]=string[j+n];
  }
  return(0);
}

