/*----------------------------------------------------------------------------
     Copyright (c) 1993 Regents of the University of California  
                     All Rights Reserved                          
 -----------------------------------------------------------------------------
  TwoWayPopen() : forks off a process and runs a progam or shell script
  using execvp.  The program has its STDOUT and STDIN redefined to
  pipes that are return in the variable (fd).  fd[0] = programs STDOUT,
  fd[1] = programs STDIN.  The output from the process can be sent a 
  number of different places, this is controlled by the variable (outputTo). 
     outputTo = IO_2_PROGRAM : means send output to pipe, (fd[0]).
     outputTo = IO_2_STDIN   : same as above.
     outputTo = IO_2_STDOUT  : send output to STDOUT of orignal program.
     outputTo = IO_2_NULL    : send output to /dev/null.
     outputT0 = IO_2_FILE    : send data to file named in the variable 
                               outputFile, file is created.
  Also see TestFdRead() to see it pipe ready to be read from.

  Developement History:
    Begun: 7/23/93 - Gilbert Hyatt

------------------------------------------------------------------------------*/
#include <stdio.h>  /* for NULL */
#include <unistd.h> /* for STDIN_FILENO & STDOUT_FILENO */
#include "miscc.h"
#include <malloc.h>

static int ParseCommand();
static int TrimSpc();

int *
TwoWayPopen (char *command, int outputTo, char *outputFile)
{
  int        pipe_to_child[2], pipe_to_parent[2];
  int        itmp, parent_pid;
  char       *optList[100];
  static int fd[2];

  if (command == NULL)                    return(NULL);
  if (pipe(pipe_to_child)  < 0)           return(NULL);
  if (pipe(pipe_to_parent) < 0)           return(NULL);

  
  ParseCommand(command, optList);
  switch(fork()){
    case -1: /***** error in fork *****/
      return(NULL);
    case 0:  /***** You are in the child ******/
      close(pipe_to_child[IO_WRITE]);         /* so parent can talk on it   */
      close(pipe_to_parent[IO_READ]);         /* so parent can listen on it */
      dup2(pipe_to_child[IO_READ], STDIN_FILENO);        /* redefine stdin  */
      close(pipe_to_child[IO_READ]);  
      switch(outputTo) {                    /* now want to define stdout to */
      case IO_2_STDOUT: break;
      case IO_2_STDIN:  dup2(pipe_to_parent[IO_WRITE], STDOUT_FILENO);
	                break;
      case IO_2_NULL:   outputFile = "/dev/null";
      case IO_2_FILE:   if((itmp = creat(outputFile, 420)) == -1) {
	                  parent_pid = getppid();
			  exit(1);
			}
	                dup2(itmp, STDOUT_FILENO);
	                close(itmp);
	                break;
      }  /* end of switch */
      close(pipe_to_parent[IO_WRITE]); 
      if(execvp(optList[0], optList) ==-1) exit(1);
    default:  /*****  You are in PARENT *****/
      close(pipe_to_child[IO_READ]);            /*  so child can read on it */
      close(pipe_to_parent[IO_WRITE]);          /* so child can write on it */
      fd[1] = pipe_to_child[IO_WRITE];
      fd[0] = pipe_to_parent[IO_READ];
      return(fd);
  }  /* end of switch */
}  /* end of asyn_poen() */


/* --------------------------------------------------------------------------*/
static int 
ParseCommand (char *command, char *optList[])
{
#define FlipTrueFalse(var)         (var = (var < 1)?1:0)
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif


  int  index, sQuote, dQuote, bQuote, ptr_2_next;
  char *tmpStr;

  index = sQuote = dQuote = bQuote = ptr_2_next = 0;
  TrimSpc(command);
  optList[index++] = command;

  for(tmpStr = command; *tmpStr != '\0'; tmpStr++) {
    if (*tmpStr == '\'') FlipTrueFalse(sQuote);
    if (*tmpStr == '"')  FlipTrueFalse(dQuote);
    if (*tmpStr == '`')  FlipTrueFalse(bQuote);
    if (sQuote || dQuote || bQuote) continue;
    
    if (isspace(*tmpStr)) {
      *tmpStr = '\0';
      ptr_2_next = TRUE;
    }  else {
      if (ptr_2_next) {
	if (*tmpStr != '\0') optList[index++] = tmpStr;
	ptr_2_next = FALSE;
      }  /* end of if-else-if */
    }  /* end of if-else */
  }  /* end of for */

  optList[index] = NULL;
}  /* end of ParseCommand() */


/* --------------------------------------------------------------------------*/
static int 
TrimSpc (char string[])
{
  int j,n,end; 
#include <ctype.h>

  j=strlen(string)-1;  /* First xter in string */
  while(isspace(string[j]) && j > 0) j--;  /* trim trailing spaces */
  string[j+1]='\0'; /* truncate */
  j=0;  /* preset */
  while(isspace(string[j]) && string[j] != '\0') j++; /* trim leading spaces */
  if(j>0)  /* shift string left */
    {
      end=strlen(string);
      for(n=0;n<end;n++) string[n]=string[j+n];
    }
  return(0);
}  /* end of TrimSpc() */




