/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
 */
/*-- FPRINT_USAGE -------------------------------------------------*/
/* Prints the usage information in the passed 'rusage' structure   */
/* in a formated way to the specified file.                        */
/*                                                                 */
/* NOTE: some values are given in pages, the size of a page may    */
/*       from system to system, currently it is 2Kbyes. Change     */
/*       the internal variable 'page' to reflect the current page  */
/*       size.                                                     */
/*                                                                 */
/* Returns:                                                        */
/*    Always 0                                                     */
/*                                                                 */
/*  Entry Requirements:                                            */
/*     FPTR: The pointer to a pre-opened file.                     */
/*     RUSAGE: The 'rusage' structure containing resource usage    */
/*             information (as obtained from 'wait3' or 'getrusage'*/
/*                                                                 */
/*  Developement History:                                          */
/*    Begun: 04/08/87 - Todd King                                  */
/*                   Under GG44 support                            */
/*-----------------------------------------------------------------*/
#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
fprint_rusage(FILE *fptr, struct rusage *rusage)
{
  int page=2;		/* Size of a page in Kbytes */

  fprintf(fptr, "\nExecution Time information:\n");
  fprintf(fptr,
    "  Time spent in user mode: %d hours, %d min., %d sec., %d msecs\n",
    rusage->ru_utime.tv_sec/3600, rusage->ru_utime.tv_sec/60,
    rusage->ru_utime.tv_sec%60, rusage->ru_utime.tv_usec/1000
    );
  fprintf(fptr,
    "  System time spent on process' behalf: %d hours, %d min., %d sec., %d msecs\n",
    rusage->ru_stime.tv_sec/3600, rusage->ru_stime.tv_sec/60,
    rusage->ru_stime.tv_sec%60, rusage->ru_stime.tv_usec/1000
    );

  fprintf(fptr,"\nMemory usage:\n");
  fprintf(fptr,"  Maximum utilized resident set size: %ld Kbytes\n",
    rusage->ru_maxrss*page);
  fprintf(fptr,"  Average shared memory: %ld Kbyte/sec\n",
    rusage->ru_ixrss*page);
  fprintf(fptr,"  Average unshared data space: %ld Kbyte/sec\n",
    rusage->ru_idrss);
  fprintf(fptr,"  Average unshared stack space: %ld Kbyte/sec\n",
    rusage->ru_isrss);

  fprintf(fptr,"\nSystem impact:\n");
  fprintf(fptr,"  Page reclaims (no I/O): %ld\n",rusage->ru_minflt);
  fprintf(fptr,"  Page faults (with I/O): %ld\n",rusage->ru_majflt);
  fprintf(fptr,"  Page swaps: %ld\n",rusage->ru_nswap);

  fprintf(fptr,"\nInput-ouput:\n");
  fprintf(fptr,"  Number of times file system performed input: %ld\n",
    rusage->ru_inblock);
  fprintf(fptr,"  Number of times file system performed output: %ld\n",
    rusage->ru_oublock);
  fprintf(fptr,"  Ipc messages sent: %ld\n",rusage->ru_msgsnd);
  fprintf(fptr,"  Ipc messages recieved: %ld\n",rusage->ru_msgrcv);
  fprintf(fptr,"  Number of signals delivered: %ld\n", rusage->ru_nsignals);
  fprintf(fptr,
    "  Number of times process voluntarly relinquished processor: %ld\n",
    rusage->ru_nvcsw);
  fprintf(fptr,
    "  Number of times process was forced to relinquish processor: %ld\n",
    rusage->ru_nivcsw);
  return(0);
}
