/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
#include <stdio.h>
#include <ctype.h>
   
/*-- GET_WORD -----------------------------------------*/
/* Function to get the next character word from the    */
/* given file. Reads only up to W_LEN characters and   */
/* returns the number of characters read as its value  */
/* The negative of the number of characters read if    */
/* the end of file is encountered during the read.     */
/* The word is placed in n_word.                       */
/*                                                     */
/* On Entry:                                           */
/*    F_PTR:  The pointer to the file to read from.    */
/*    N_WORD: Character string which will contain the  */
/* 	      next word read. Must be alt least W_LEN  */
/*    DELIM : Character string which will contain the  */
/* 	      deliminator of the current word. Must be */
/*	      at least W_ELN in dimension.             */
/*    W_LEN:  The length of N_WORD or longest word     */
/*            allowed, which ever is smaller.          */
/* Returns:                                            */
/*  The length of the word, -1 if end of file is       */
/*  encountered                                        */
/*                                                     */
/* Development History:                                */
/*    Begun: 8/31/85 - Todd King                       */
/*          Under GY49 support.                        */
/*                                                     */
/*  Version:                                           */
/*     %W%      (UCLA/IGPP)     %G%                    */
/*-----------------------------------------------------*/
getword(FILE *f_ptr, char n_word[], char delim[], int w_len)
{

  char in_c;
  int n,j;

  n=0;
  strcpy(delim,"");

/*-- Extract word --*/

  if((in_c=fgetc(f_ptr)) == EOF) return(-1);
  while((isalpha(in_c) || isdigit(in_c)) && (n < w_len))
  {
    n_word[n]=in_c;
    n++;
    in_c=fgetc(f_ptr);
    if(in_c == EOF) break;
  }
  n_word[n]='\0';
  if(in_c == EOF) return(n);

/*-- Extract deliminator --*/

  j=0;
  while(!(isalpha(in_c) || isdigit(in_c)) && (j < w_len))
  {
    delim[j]=in_c;
    j++;
    in_c=fgetc(f_ptr);
    if(in_c == EOF) break;
  }
  ungetc(in_c,f_ptr);
  delim[j]='\0';

  return(n);
}
