/*----------------------------------------------------------------
   Defines a fixed pattern consisting of the string past.

   Entry Requirements:
      string  : A string which will be the fixed pattern.

   Return Value:
      NULL : If pattern is NULL or unable to create instances of
	     required variables.
      otherwise : A pointer to a PATTERN structure which contains
	     a token list.

   Development History:
      Begun: 11/12/92 - Todd King

   Version:
      %W%   (UCLA/IGPP)    %G%
------------------------------------------------------------------*/
#include <string.h>
#include "pattern.h"

PATTERN *
pattern_fixed (char string[])
{
   PATTERN *p;

   p = pattern_make();
   if(p == NULL) return(NULL);
   p->type = PATTERN_TYPE_FIXED;
   p->text = strdup(string);
   p->text_len = strlen(p->text);
   if(p->text == NULL) {
      pattern_free(p);
      p = NULL;
   }

   return(p);
}
