
/*----------------------------------------------------------------
   Checks if a string matches a given pattern. The pattern
   must be a token list produced by pattern_parse().

   Entry Requirements:
      string: The string of text to compare to the pattern.
      pattern : A token list defining the pattern to compare
		the string to. Produced by pattern_parse().

   Return Value:
      1 : If the string matches the pattern.
      0 : If it does not.

   Development History:
      Begun: 03/02/92 - Todd King

   Version:
      %W%    (UCLA/IGPP)   %G%
------------------------------------------------------------------*/
#include "pattern.h"

int 
pattern_match (char string[], PATTERN *pattern)
{
   PATTERN *p;
   char *s;

   s = string;
   for(p = pattern; p != NULL; p = p->next) {
      switch(p->type) {
	 case PATTERN_TYPE_SINGLE_CHAR:
	    if(*s == '\0') return(0);
	    s++;
	    break;
	 case PATTERN_TYPE_MULTIPLE_CHAR:
	    if(p->next == NULL) return(1);
	    while(p->next->type == PATTERN_TYPE_MULTIPLE_CHAR) {
	       p = p->next;
	    }
	    if(p->next == NULL) return(1);
	    switch(p->next->type) {
	       case PATTERN_TYPE_SINGLE_CHAR:
		  break;
	       case PATTERN_TYPE_FIXED:
		  for( ; *s != '\0'; s++) {
		     if(strncmp(s, p->next->text, p->next->text_len) == 0) { 
			s += p->next->text_len;
			p = p->next;	/* Skip this check - we've done it */
			break;
		     }
		  }
		  break;
	    }
	    break;
	 case PATTERN_TYPE_FIXED:
	    if(*s == '\0') return(0);
	    if(strncmp(s, p->text, p->text_len) == 0) { s += p->text_len; }
	    else { return(0); }
	    break;
	 default:
	    return(0);
      }
   }

   if(*s != '\0') return(0);
   return(1);
}

