/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
#include "timec.h"

/*-- compile_arb_time_style --------------------------------------------
   Compiles the time format specifier into a list of tokens.

   Entry Requirements:
     string: The free format time specification.
     tt: Assigned the list of tokens corresponding to the
	 time specification.

   Return Value:
     Always 1.

   Development History:
      Begun: 4/2/90 - Todd King

   Version:
       %W%    (UCLA/IGPP)   %G%
----------------------------------------------------------------------*/
int 
compile_arb_time_style (char string[], TIME_TOKEN *tt)
{
  int i, n;
  int loc;
  int at[TIME_MAX_FORMAT_STR];

  for(i = 0; i < TIME_MAX_FORMAT_STR; i++) {
    at[i] = -1;
  }

/* Determine the order of tokens in the string */
  i = 0;
  while(Time_token_kw[i] != NULL) {
    if((loc = findstr(Time_token_kw[i], string, '"')) != -1) {	/* found it */
      at[loc] = i;
    }
    i++;
  }

/* Replace tokens with format statements */
  i = 0;
  while(Time_token_kw[i] != NULL) {
    findrep(string, Time_token_kw[i], "%d");
    i++;
  }

/* Record order of tokens in compiler structure */
  strncpy(tt->fmt_spec, string, TIME_MAX_FORMAT_STR);

  n = 0;
  for(i = 0; i < TIME_MAX_FORMAT_STR; i++) {
    if(at[i] != -1) {
      tt->tokens[n] = at[i];
      n++;
      if (n >= TIME_MAX_TOKENS) break;
    }
  }
  tt->ntokens = n;

  return(1);
}

