/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
#include "timec.h"

/*-- doy -------------------------------------------------------
  Determines the day of year for a given day of a month in 
  a specific month and year. The first day of year has a value
  of 1.

  Entry Requirements:
    yr: The base year.
    mon: The base month.
    day: The day of the month.

  Return Value:
    The day of year.

   Version:
       %W%    (UCLA/IGPP)   %G%
--------------------------------------------------------------*/
int 
doy (int yr, int mon, int day)
{
  int imon,dayofyr;
  dayofyr = 0;
  for(imon=1; imon<mon; imon++) dayofyr += maxdaymon(imon,yr);
  return(dayofyr + day);
}


