/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
#include "timec.h"

/*-- localcline -------------------------------------------------
  Determines the number of seconds from the beginning of the 
  reference year (1966) until the moment this call is made. The
  time which corresponds to the moment is taken from the system clock.

  Entry Requirements:
    None.

  Return Value:
    The number of seconds from the beginning of the reference year
    to the present.

   Version:
       %W%    (UCLA/IGPP)   %G%
---------------------------------------------------------------*/
#ifdef VMS
#include <time.h>
#else
#include <sys/time.h>
#endif
double 
localcline (void)
{
  long clock;
  struct tm *dat;
  double sectime();

    time(&clock);
    dat = localtime(&clock);
    return (sectime(dat->tm_year,dat->tm_mon+1,dat->tm_mday,
		    dat->tm_hour,dat->tm_min,(double)dat->tm_sec));
}


