/*---------------------------------------------------------------*/ 
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

#include "timec.h"

/*-- parse_arb_time_str -------------------------------------
  Parses a free fromat time string and returns a binary
  time value. The expected format of the time in the string
  is determined by the list of time tokens.

  Entry Requirements:
    string: the string with a time vlaue to parse.
    tt: The list of time tokens which defines how to parse
	the string.

  Return Value:
    The seconds from the beginning of the reference year (1966)
    to the time specified in string.

   Development History:
      Begun: 4/2/90 - Todd King

   Version:
       %W%    (UCLA/IGPP)   %G%
-------------------------------------------------------------*/
double 
parse_arb_time_str (char string[], TIME_TOKEN *tt)
{
  int i;
  int value[TIME_MAX_TOKENS];
  int year, mon, day, doy;
  int hour, min, sec, msec;
  float fsec;

  year = REFYR;
  mon = 0;	/* -1 to make it possible to detect if set */
  day = 0;
  doy = 0;
  hour = 0;
  min = 0;
  sec = 0;
  msec = 0;

  for(i = 0; i < TIME_MAX_TOKENS; i++) {
     value[i] = 0;
  }

/* LOOK OUT! Hard coded references. In the following function
   each element in 'value' is explicitly named and
   so must have TIME_MAX_TOKEN entries. 
*/
  sscanf(string, tt->fmt_spec, &value[0], &value[1], &value[2], 
    &value[3], &value[4], &value[5], &value[6], &value[7],
    &value[8], &value[9], &value[10], &value[11], &value[12],
    &value[13], &value[14]
    );

  for(i = 0; i < tt->ntokens; i++) {
    switch(tt->tokens[i]) {
      case FMT_YEAR:
	year = value[i];
	break;
      case FMT_MONTH:
	mon = value[i];
	break;
      case FMT_DAY:
	day = value[i];
	break;
      case FMT_DOY:
	doy = value[i];
	break;
      case FMT_HOUR:
	hour = value[i];
	break;
      case FMT_MIN:
	min = value[i];
	break;
      case FMT_SEC:
	sec = value[i];
	break;
      case FMT_MSEC:
	msec = value[i];
	break;
    }
  }

  if(doy != 0 && (day == 0 && mon == 0)) { /* determine day, mon */
    monthday(year, doy, &mon, &day);
  } else {
    if(day == 0) day = 1;
    if(mon == 0) mon = 1;
  }


  fsec = sec + msec/1000.0;
  return(sectime(year, mon, day, hour, min, fsec));
}

