/*---------------------------------------------------------------*/ 
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

#include "timec.h"

/*-- strtotime --------------------------------------------------
  Translates an ascii time string into the number of seconds
  from the beginning of the reference year (1966).
  
  Entry Requirements:
    str: The string containing the date and time specification in
	 the format: yr:mn:dy:hr:mi:sc.msec

   Return Value:
     The numberof seconds from the beginning of the reference year.
 
 Development history:
     Begun: 4/11/89 - Scott Bendar
  modified: 4/13/89 - Scott Bendar -- fixed a bug
	under (GY49) support


   Version:
       %W%    (UCLA/IGPP)   %G%
-------------------------------------------------------*/
double 
strtotime (char *str)
{
  char *timep[6];
  int count;
  int i = 0;
  int yr = 1966,
      mon = 1,
      day = 1,
      hour = 0,
      min = 0;
  float sec = 0.0;
  double atof(), sectime();
  
  count = mop2(str, "*/*/* *:*:*", timep);

  if (count > 0)
    yr = atoi(timep[i++]);

  if (count > 1)
    mon = atoi(timep[i++]);

  if (count > 2)
    day = atoi(timep[i++]);

  if (count > 3)
    hour = atoi(timep[i++]);

  if (count > 4)
    min = atoi(timep[i++]);

  if (count > 5)
    sec = atof(timep[i++]);

  return sectime(yr, mon, day, hour, min, sec);
}

