/*---------------------------------------------------------------*/ 
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

#include "timec.h"

/*-- time_style_width --------------------------------------------
  Determines the maximum width for a specific time style.
  
  Entry Requirements:
    style: The token for a time style.
    
  Return Value:
   Returns the minimum width of a specific time style.

   Version:
       %W%    (UCLA/IGPP)   %G%
-----------------------------------------------------------------*/
int 
time_style_width (int style)
{
   int width;

   switch(style) {
     case AMERDATE:
       width = 24;
       break;
     case EURODATE:
       width = 22;
       break;
     case ABBRAMER:
       width = 25;
       break;
     case ABBREURO:
       width = 24;
       break;
     case LONGAMER:
       width = 30;
       break;
     case LONGEURO:
       width = 30;
       break;
     case NUMERICAL:
       width = 20;
       break;
     case DAYNUMBER:
       width = 21;
       break;
     case JAPANDATE:
       width = 23;
       break;
     case NIPPONDATE:
       width = 23;
       break;
     case HIGHLOW:
       width = 23;
       break;
     case ISEEDATE:
       width = 28;
       break;
     case DFS_STYLE:
       width = 24;
       break;
     case ABBRDFS_STYLE:
       width = 23;
       break;
     case PDS_STYLE:
       width = 24;
       break;
     case ISO:
       width = 20;
       break;
     case BINARY:
       width = 24;
       break;
     case GLL_SCLK:
       width = 14;
       break;
  }
  return(width);
}

