/*---------------------------------------------------------------*/ 
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

#include "timec.h"

/*-- validtime -------------------------------------------
  Determines if components of a time value are withing 
  vlaid ranges. 

  Entry Requirements:
     yr: The year 
    mon: The month in the year
    day: the day of month
     hr: The hour of the day
    min: The minutes in the hour
    sec: The seconds in the minutes

  Return Value:
     Returns 1 if the passed time is withing valid range
     0 otherwise.

   Version:
       %W%    (UCLA/IGPP)   %G%
----------------------------------------------------------*/
int 
validtime (long int yr, long int mon, long int day, long int hr, long int min, double sec)
{
  if(yr <= 0 || yr >= 2100) return(0);
  else if (mon <= 0 || mon > 12) return(0);
  else if (day <= 0 || day > 31) return(0);
  else if (mon == 4 || mon == 6 || mon == 9 || mon == 11)
     {
     if (day > 30) return(0);
     }
  else if (mon == 2 && day > 29) return(0);
  else if ((mon == 2 && yr%4 != 0) && day > 28) return(0);
  else if (hr <= 0 || hr > 23) return(0);
  else if (min <= 0 || min > 59) return(0);
  else if (sec <= 0.0 || sec >= 60.0) return(0);
  else return(1);
}

