/*---------------------------------------------------------------*/ 
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

#include "timec.h"

/*--yrmonday ----------------------------------------------
 Calculates the year, month, day, hour, minutes and seconds
 given the floating point seconds from Jan 1, in the 
 reference year (1966)

  Entry Requirements:
    sectime: The number of seconds from the beginning of the 
	   reference year.
    yr: Assigned the year.
    mon: Assigned the month.
    day: Assigned the day of the month.
    hr: Assigned the hour or the day.
    min: Assigned the minutes of the hour.
    sec: Assigned the seconds and milliseconds of the minute.

  Return Value:
    undefined.

   Version:
       %W%    (UCLA/IGPP)   %G%
---------------------------------------------------------*/
int 
yrmonday (double sectime, int *yr, int *mon, int *day, int *hr, int *min, float *sec)
{
  double secpermo, secsyr;
  double fmod(), secperyr();

  *yr = REFYR;
  while(sectime > (secsyr = secperyr(*yr)) - 0.5e-3) {
    sectime -= secsyr;
    *yr += 1;
  }
  *mon = 1;
  while(sectime > (secpermo = 86400.0*maxdaymon(*mon,*yr)) - 0.5e-3) {
    sectime -= secpermo;
    *mon += 1;
    if(*mon == 13) {*mon = 1; *yr += 1;}
  }
  if(sectime < 0) sectime = 0;
  *day = sectime/86400 + 1;  
  sectime = fmod(sectime,86400.0);
  *hr = sectime/3600.0;
  sectime = fmod(sectime,3600.0);
  *min = sectime/60.0;
  sectime = fmod(sectime,60.0);
  *sec = sectime;
  return;
}

