/*---------------------------------------------------------------------
      Copyright(c) 1993 Regents of the University of California
      All rights reserved.
 
   Redistribution and use in source and binary forms are permitted
   provided that the above copyright notice and this paragraph are
   duplicated in all such forms and that any documentation,
   advertising materials, and other materials related to such
   distribution and use acknowledge that the software was developed
   by the University of California, Los Angeles.  The name of the
   University may not be used to endorse or promote products derived
   from this software without specific prior written permission.
   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
-----------------------------------------------------------------------*/
/*------------------------------------------------------------------------
   Include file for ffextract.c

   Development History:
      Begun: 1/4/93 - Kirk Ketefian

   Version:
     @(#)ffextract.h	1.6        (UCLA/IGPP)     06 Jul 1994
--------------------------------------------------------------------------*/

#ifndef ffextract_h
#define ffextract_h    1

#include "ffio.h"	/* Flatfile */


/*------------------------------------------------------------------------*/
/*----- DEFINITIONS TO DETERMINE WHAT SYSTEM THE USER IS ON --------------*/
/*------------------------------------------------------------------------*/
/*                                                                        */
/* @@@@@@@@@  M A C H I N E   A R C H I T E C T U R E  @@@@@@@@@          */
/* May be one of the following: "hp", "ibm", "msb", "pc", "sun", or "vax" */
/*                                                                        */
#define CURRENT_PLATFORM   "sun"                                          /*
---------------------------=====                                          */
/*                                                                        */
/* @@@@@@@@@  O P E R A T I N G   S Y S T E M  @@@@@@@@@                  */
/* Define one of the following: POSIX, MSDOS, VMS, or MACOS               */
/*                                                                        */
#define POSIX  1                                                          /* 
--------========                                                          */
#define MAX_DEVICE_LEN  128    /* longest device (drive) name possible    */
/*                                                                        */
/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/


/* screen manipulation related definitions */

#define MAX_LINES          19   /* set at 5 less than lines on terminal */
#define MAX_WIDTH          78   /* set at 2 less than terminal width    */


/* Definitions for function communications */

#define DB_SUCCESS          1 
#define DB_FAILURE          0


/* Definitions for data conversion and output */

#define ASCII_FRMT       11
#define BINARY_FRMT      12

#define MAX_TEMP_LENGTH   600


int main (int argc, char *argv[]);
void do_help (FILE *fptr);
int find_record (FLATFILE *ffptr, char refname[]);
int list_recs (FLATFILE *ffptr, unsigned long start_no);
void Print_list_help (FILE *fptr);
int do_calc_and_header (FLATFILE *ffptr, int begin, int *end, unsigned long top_rec, unsigned long bottom_rec);
int pad_front_with_spaces (char *string, int count);
int list_flatfile (char refname[], FLATFILE *ffptr);
int remove_num_sign (char *string);
int remove_extension (char *filename);
void PrintDES (FLATFILE *ffptr, FILE *outfile);
int init_newdesc (void);
int Sun_To_Format (FLATFILE *ffptr);
int Format_To_Sun (FLATFILE *ffptr);
int PickVarFormat (char *formatstr);
int extract_flatfile (int style, FILE *fptr, FLATFILE *ffptr);
int ascii_extract (FLATFILE *ffptr, unsigned long start_no, FILE *fptr);
void PrintHeader (FLATFILE *ffptr, FILE *outfile);
int binary_extract (FLATFILE *ffptr, unsigned long start_no, FILE *fptr);
int write_desc (FILE *desc_fptr, int Is_ascii);
int write_hed (FILE *hed_fptr);
int write_abs (FILE *abs_fptr);
int exists_file (char *filename);
int set_time_style (char *time_style);

#endif ffextract_h
