/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffopen_segment ----------------------------------------------------
  Opens the next segment is a virtual flatfile.
  Returns FF_SUCCESS upon successful completion or FF_FAILURE
  upon error or encountering the end of file.

   Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )
 
  Return Value:
     FF_SUCCESS: If a record was read.
     FF_FAILURE: If the flatfile pointer is invalid or
		 if the end of file is reached.

  Development History:
    Begun: 11/1/89 - Todd King
---------------------------------------------------------------------*/
#include "ffio.h"

int 
ffopen_segment (FLATFILE *ffptr)
{
   char buffer[MAX_FILENAME + 1];

   if(ffptr == NULL) return(FF_FAILURE);
   if(ffptr->vinfo.fptr == NULL) return(FF_FAILURE);

   /* Read the next line in the virtual flatfile list of components */ 

   if(fgets(buffer, sizeof(buffer), ffptr->vinfo.fptr) == NULL) {
      return(FF_FAILURE);
   }

   /* Close data file if currently open */

   if(ffptr->data != NULL) {
      fclose(ffptr->data);
      ffptr->data = NULL;
   }

   buffer[strlen(buffer) - 1] = '\0';
   strcat(buffer, ".DAT");

   ffptr->data = fopen(buffer, "rb");
   if(ffptr->data == NULL) return(FF_FAILURE);

   return(FF_SUCCESS);
}
