/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffwrite_abs ----------------------------------------------
  Writes the abstract to a flatfile. The abstract is passed
  as an array of chracter strings terminated by a zero length
  string.

  Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )
    abs: An array of strings which contains the information
	 to place in the abstract. The list is terminated with
	 a zero length string.

  Return Value:
    FF_SUCCESS if the write was successful.
    FF_FAILURE if the flatfile pointer is invalid.

  Development History:
     Begun: 7/28/89 - Todd King
---------------------------------------------------------------*/
#include "ffio.h"

int 
ffwrite_abs (FLATFILE *ffptr, char *abs[])
{
   int i = 0;

   if(ffptr == NULL) return(FF_FAILURE);

   while(strlen(abs[i]) != 0) {
     fprintf(ffptr->abs, "%s\n", abs[i]);
     i++;
   }
   return(FF_SUCCESS);
}

