/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffwrite_hed --------------------------------------------
  Writes the header file for a flatile. This should be
  called after all data has been written to the data
  file.

  Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )

  Return Value:
    FF_SUCCESS if the write was successful,
    FF_FAILURE if the flatfile pointer is invalid.

  Development History:
     Begun: 7/28/89 - Todd King
------------------------------------------------------------*/
#include <time.h>
#include "ffio.h"

int 
ffwrite_hed (FLATFILE *ffptr)
{
   char tmpname[FF_HED_FNAME + 1];
   char tmppath[FF_HED_PATH + 1];
   char tmpowner[FF_HED_OWNER + 1];
   char tmpcdate[FF_HED_CDATE + 1];
   time_t clock;
   int i;
   unsigned int close_it = FALSE;
   int itmp;

   if(ffptr == NULL) return(FF_FAILURE);

/* If file not pre-opened, open it and set flag to close it later */
   
   if(! (ffptr->open_status & FF_HED) ) {
     if(ffopen_select(ffptr, "w", FF_HED) == NULL) { return(FF_FAILURE); }
     close_it = TRUE;
   }
   rewind(ffptr->hed);

   if(ffptr->style == FF_STYLE_VIRTUAL) {
      fwrite(FF_VIRTUAL_MAGIC_COOKIE, sizeof(FF_VIRTUAL_MAGIC_COOKIE), 
            1, ffptr->hed);
   } else {

   /* Search for file name portion */
      for(i = strlen(ffptr->fname) - 1; i >= 0; i--) {
	   /**** VERY system dependent ****/
#ifdef vms
	 if(ffptr->fname[i] == ']' || ffptr->fname[i] == ':') /* a deliniator */
#endif
#ifdef unix
	 if(ffptr->fname[i] == '/' || ffptr->fname[i] == '~') /* a deliniator */
#endif
	 {
	   if(i < FF_HED_PATH) { /* then copy jsut the first i characters */
	     itmp = i;
	   } else { /* Use as much as will fit */
	     itmp = FF_HED_PATH;
	   }
	   strncpy(tmppath, ffptr->fname, itmp);
           tmppath[itmp] = '\0';
	   strncpy(tmpname, &ffptr->fname[i + 1], FF_HED_FNAME);
	   break;
	 }
      }
      if(i <= 0) {  /* Just filename specified */
	strncpy(tmpname, ffptr->fname, FF_HED_FNAME);
	getcwd(tmppath, FF_HED_PATH);
      }
      clock = time(NULL);
      strncpy(tmpowner, getenv("USER"), FF_HED_OWNER);

      strncpy(tmpcdate, ctime(&clock), FF_HED_CDATE);
      tmpcdate[24] = '\0';	 /* removes new line which is in string */

   /* Insure proper termination of all strings */
      tmppath[FF_HED_PATH] = '\0';
      tmpname[FF_HED_FNAME] = '\0';
      tmpowner[FF_HED_OWNER] = '\0';

   /* Write the record */
      fprintf(ffptr->hed, "%-*s%-*s%-*s%-*s%*d%*d\n", FF_HED_FNAME, tmpname,
	 FF_HED_PATH, tmppath, FF_HED_CDATE, tmpcdate,
	 FF_HED_OWNER, tmpowner, FF_HED_NCOLS, ffptr->ncols,
	 FF_HED_NRECS, ffptr->nrecs);

   }

   if(close_it) { ffclose_select(ffptr, FF_HED); }
   return(FF_SUCCESS);
}
