/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
 */
/* -- ALLOCSTR --------------------------------------------- */
/* Allocates memory for the string pointed to by the         */
/* parameter passed in and copies the string into the newly  */
/* allocated area.   Useful when you have a character ptr    */
/* pointing to temporary memory, and permanent storage is    */
/* needed.                                                   */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*   A character pointer.                                    */
/*                                                           */
/* RETURN VALUES:                                            */
/*   A character pointer to newly allocated area (or NULL if */
/*   malloc fails).                                          */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  2/2/87  - Marco Zagha                */
/*                     Under GG44 support.                   */
/* --------------------------------------------------------- */
char *
allocstr (char *in_ptr)
{
#include <stdio.h>

  char *malloc();
  char *new_ptr;

  new_ptr = malloc((unsigned)(strlen(in_ptr)+1));
  if (new_ptr == NULL) return NULL;
  strcpy(new_ptr, in_ptr);
  return(new_ptr);
}


