/*---------------------------------------------------------------*/
/*   Copyright (c) 1993 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- AbbrevMakeNode ------------------------------------------------
 Creates an instance of an abbreviation definition.

 Entry Requirements:
    abbrev : The abbreviation text.
    trans : The translation text.

 Return Values:
    NULL : if unable to create an abbreviation node,
    otherwise : The pointer to abbreviation node.
                                        
 Development History:                   
   Begun: 03/15/93 - Todd King          
                                        
  Version:                              
     %W%      (UCLA/IGPP)     %G%
--------------------------------------------------------------------*/
#include "abbrev.h"	/* For AbbrevNode and NULL */
#include <string.h>	/* For strdup() */

static AbbrevNode *
AbbrevMakeNode (char abbrev[], char trans[])
{
   AbbrevNode	*node;

   node = (AbbrevNode *) calloc(1, sizeof(AbbrevNode));
   if(node != NULL) {
      node->abbrev = strdup(abbrev);
      if(node->abbrev == NULL) {
	 free(node);
	 return(NULL);
      }
      node->trans = strdup(trans);
      if(node->trans == NULL) {
	 free(node->abbrev);
	 free(node);
	 return(NULL);
      }
   }
   return(node);
}

/*-- AbbrevPushNode ------------------------------------------------
 Creates an instance of an abbreviation definition and 
 adds it to the passed list of abbreviations.

 Entry Requirements:
    abbrevList : The list of abbreviations to add the new abbreviation
		 definition to.
    abbrev : The abbreviation text.
    trans : The translation text.

 Return Values:
    NULL : if unable to create an abbreviation and add it to the list.
    otherwise : The pointer to the first item in the list.
                                        
 Development History:                   
   Begun: 03/15/93 - Todd King          
                                        
  Version:                              
     %W%      (UCLA/IGPP)     %G%
--------------------------------------------------------------------*/
AbbrevNode *
AbbrevPushNode (AbbrevNode *abbrevList, char abbrev[], char trans[])
{
   AbbrevNode	*node;
   AbbrevNode	*tmp;

   node = AbbrevMakeNode(abbrev, trans);
   if(node != NULL) {
      if(abbrevList != NULL) {
	 for(tmp = abbrevList; tmp->next != NULL; tmp = tmp->next) {
	   /* Find last item */
	   continue;
	 }
	 tmp->next = node;
	 node = abbrevList;
      }
   }
   return(node);
}
