/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- MOP -----------------------------------------*/
/* MOP - Mask Oriented Parser. Parses a line of   */
/* text according to the mask definition. The     */
/* mask has stars (*) placed where variables are. */
/* The parts of the text are copied into the      */
/* successive elements of a given array of string */
/* pointers. The original input mask is not       */
/* altered. the original input line is.           */
/* For example, a mask like: *(*) will extract    */
/* the string 'sin' and '22' from the line        */
/* 'sin(22)'.                                     */
/*                                                */
/*  Returns the number of parts found,            */
/*   -1 otherwise                                 */
/*                                                */
/*  Entry Requirements:                           */
/*    line: the line to parse.                    */
/*    mask: the mask to apply to the line.        */
/*    part: array of character pointers to place  */
/*          copies of the varaible portions of    */
/*          the line in.                          */
/*                                                */
/*  Developement History:                         */
/*    Begun: 12/29/86 - Todd King                 */
/*         Under GG44 support.                    */
/*                                                */
/*  Version:                                      */
/*     %W%      (UCLA/IGPP)     %G%               */
/*------------------------------------------------*/
int 
mop (char *line, char *mask, char *part[])
{
  char tempstr[1024];
  char tstr[1024];
  char *mpart[256];
  int i, cnt, np, at;
  char *endofline;
  char *sptr;

  if(strlen(mask) == 0) return(0);
  strncpy(tempstr, mask, 1024);
  np=parse(tempstr, mpart, "*", 256);
  sptr = (&line[0]);
  endofline = sptr + strlen(line);
  cnt=0;
  for(i = 0; i < np; i++)
  {
    if(strlen(mpart[i]) == 0) continue;	/* No preceeding text required */
    at = findstr(mpart[i], sptr, '"');
    if(at < 0 ) 
    {
      return(-1);
    }
    if(i == 0 && strlen(mpart[i]) != 0)   /* No preceeding variable */
    {
      if(at == 0)
      {
	sptr = sptr + at + strlen(mpart[i]);
	continue;
      }
      else return(-1);
    }
    part[cnt] = sptr;
    sptr[at] = '\0';
    sptr = sptr + at + strlen(mpart[i]);
    cnt++;
    if(sptr > endofline) return(cnt);
  }
  if(strlen(mpart[np-1]) == 0) 		/* Handle variable at end of line */
  {
    part[cnt] = sptr;
    cnt++;
  }
  return(cnt);
}

