/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/
/*---------------------------------------------------------------
  BufFixSizeTo(int num_buf)
    When this funcion is called it fixes the size of the buffer
    list and makes it circular.  If more record are stored in the
    list than the size of num_buf, then the began records are 
    overwriting, and the start and end pointer is moved down.
    So there can on be num_buf records in the list.

  Return:
    TRUE or FLASE.
 
  Entry Requirements:
    int num_buf: maxium number of records.
 
  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
  ---------------------------------------------------------------*/

#include <malloc.h>
#include "pipec.h"

int 
BufFixSizeTo (int num_bufs)
{
  int    index;
  RECPTR *oldlast, *oldlastnext;

  extern BUFFER_HEAD  _Rbuffer;

  if (_Rbuffer.nbufs == num_bufs) return(TRUE);
  if (num_bufs < 0)               return(FALSE);
  
  

  if (num_bufs > _Rbuffer.nbufs) {
    for (index = 0; index < (num_bufs - _Rbuffer.nbufs); index++) {
      oldlastnext = _Rbuffer.last->next;
      oldlast     = _Rbuffer.last;

      if ((_Rbuffer.last->next = (RECPTR *) BufMalloc(sizeof(RECPTR))) == NULL)
	{_Rbuffer.end->next   = oldlastnext; return(FALSE);}
      _Rbuffer.last           = _Rbuffer.last->next;
      _Rbuffer.last->next     = oldlastnext;
      _Rbuffer.last->vmrecnum = BufRealMem;

      if ((_Rbuffer.last->data  = BufMalloc(_Rbuffer.recl)) == NULL) {
	free(_Rbuffer.last);
	_Rbuffer.last          = oldlast;
	_Rbuffer.last->next    = oldlastnext;
	return(FALSE);
      } /* end of if */

    }  /* end of for */

    _Rbuffer.nbufs     = num_bufs;
  } else 
    for (index = 0; index < (_Rbuffer.nbufs - num_bufs); index++)
      BufDeleteRec(1);

  _Rbuffer.num_fixed = (num_bufs)?TRUE:FALSE;
  return(TRUE);
}  /* end of BufFixSizeTo() */


