/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/
/*---------------------------------------------------------------
  BufIsInListAlready(char* columns) -
    Test to see in any record in the buffer list has columns 
    "column[]" equal the one presently in the flow.  This 
    function helps if you want a list of unique items.  Or to count
    the number of time a recor appears.  Only the columns in the
    array are looked at in the comparison.

  Return:
    number of record if is in list, else 0
 
  Entry Requirements:
    char* columns[]: area of column names.
 
  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
  ---------------------------------------------------------------*/

#include "pipec.h"

int 
BufIsInListAlready (char *columns[])
{
  extern BUFFER_HEAD  _Rbuffer;
  int                 test, recnum, index;
  char                *data;
  RECPTR              *ptr;

  double              getcolval();
  double              buffgetcolval();

  recnum = 0;
  for (ptr = _Rbuffer.first; ptr != _Rbuffer.end; ptr = ptr->next) {
    test = TRUE;
    recnum++;
    data = BufMapData(ptr);
    for (index = 0; columns[index] != NULL; index++) 
      if (getcolval(columns[index]) != buffgetcolval(data, columns[index])) test = FALSE;
    if (test == TRUE) {
      _Rbuffer.last_request = ptr;
      _Rbuffer.num_last_req = recnum;
      return(recnum);
    }  /* end of if */
  }  /* end of for */
  return(0);
}  /* end of BufIsInListAlready() */
      
