/*---------------------------------------------------------------*/
/*   Copyright (c) 1993 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
 */

#include <sys/param.h>	/* For MAXPATHLEN */

char xxFittingName[MAXPATHLEN + 1];

/*------------------------------------------------
  Sets a global variable with the value of the 
  fitting name.

  Entry Requirements:
      name : The name of the fitting.

  Developement History:
    Begun: 04/30/93  - Todd King
---------------------------------------------------*/

int 
setFittingName (char name[])
{
   strncpy(xxFittingName, name, MAXPATHLEN);
   xxFittingName[MAXPATHLEN] = '\0';	/* Proper termination */
   return(1);
}

/*------------------------------------------------
  Retrieves the global variable which contains 
  the value of the fitting name.

  Entry Requirements:
      NONE

  Developement History:
    Begun: 04/30/93  - Todd King
---------------------------------------------------*/

char *
getFittingName (void)
{
   return(xxFittingName);
}
