/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- COLSORT -----------------------------
 Returns the sort order associated with
 the given column index. Returns -1 if
 the index is invalid, the sort order
 number otherwise.
 The index count starts at 1.

 Entry Requirements:
    COLNAME: The short column name for
             the desired information.

 History:
   Begun: 3/17/86 - Todd King
      Under GH06 support.
  Edited:04/14/94 - Gilbert Hyatt
    Now uses pipec.h as entry point
    into the library.
----------------------------------------*/

#include "pipec.h"

int 
colsort (char colname[]) 
{
  extern DESC Desc[];
  extern int Ndesc;

  int cindex; 
  cindex=colnum(colname); 
  cindex--;

  if(cindex < 0) return(-1);  /* No can do */
  return(Desc[cindex].sort);
}
