/*---------------------------------------------------------------*/
/*   Copyright (c) 1991 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/

/*-- dfs_buffer_nextrec ---------------------------------------------
   Returns the record number of where the next record will be written.

   Entry Requirements:
       buffer: A pointer to a record buffer (created by make_buffer())

   Development History
      Begun: 04/12/91 - Todd King
      Edited:04/14/94 - Gilbert Hyatt
        Now uses pipec.h as entry point into the library.
---------------------------------------------------------------*/

#include "pipec.h"

extern char *Rbuffer;	/* DFS working record */

int 
dfs_buffer_nextrec (DFS_RECBUFF *buffer)
{
   return((buffer->first_rec + buffer->nrecs) % buffer->max_recs);
}
